/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.SchemaVersion;
import com.imcode.services.SchemaVersionService;
import com.imcode.utils.DatabaseWorker;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/schema_versions"})
public class SchemaVersionController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    private SchemaVersionService schemeVersionService;
    @Autowired
    private ServletContext servletContext;

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView migrate(@RequestParam(value="file") CommonsMultipartFile multipartFile, @RequestParam(value="description", required=false) String description, WebRequest webRequest) {
        SchemaVersion currentVersion = this.createCurrentVersion(multipartFile.getOriginalFilename(), description);
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, currentVersion, this.servletContext);
        if (!databaseWorker.runScript((MultipartFile)multipartFile)) {
            this.schemeVersionService.delete((Object)currentVersion.getId());
        } else {
            databaseWorker.createVersionDump();
        }
        return new ModelAndView("redirect:/test.html");
    }

    @RequestMapping(value={"/current"}, method={RequestMethod.GET})
    @ResponseBody
    public SchemaVersion getCurrentSchemaVersion(WebRequest webRequest) {
        return this.schemeVersionService.findCurrentVersion();
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<SchemaVersion> getAllSchemaVersion(WebRequest webRequest) {
        return this.schemeVersionService.findAll();
    }

    @RequestMapping(value={"/current/{version}"}, method={RequestMethod.POST})
    @ResponseBody
    public SchemaVersion migrateToVersion(@PathVariable(value="version") String version, WebRequest webRequest) {
        SchemaVersion schemaVersion = this.schemeVersionService.findVersion(version);
        if (schemaVersion.getCurrent().booleanValue()) {
            return schemaVersion;
        }
        SchemaVersion currentVersion = this.schemeVersionService.findCurrentVersion();
        currentVersion.setCurrent(Boolean.valueOf(false));
        this.schemeVersionService.save((Object)currentVersion);
        schemaVersion.setCurrent(Boolean.valueOf(true));
        this.schemeVersionService.save((Object)schemaVersion);
        List schemaVersionList = this.schemeVersionService.findAll();
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, schemaVersion, this.servletContext);
        databaseWorker.migrateToVersion();
        this.schemeVersionService.findAll().stream().forEach(schema -> this.schemeVersionService.delete((Object)schema.getId()));
        this.schemeVersionService.save((Iterable)schemaVersionList);
        return schemaVersion;
    }

    @RequestMapping(value={"/dump/{version}"}, method={RequestMethod.GET})
    public ModelAndView getVersionDump(@PathVariable(value="version") String version, HttpServletResponse httpServletResponse, WebRequest webRequest) {
        SchemaVersion schemaVersion = this.schemeVersionService.findVersion(version);
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, schemaVersion, this.servletContext);
        databaseWorker.saveVersionDumpInResponse(httpServletResponse);
        return new ModelAndView("redirect:/");
    }

    @RequestMapping(value={"/dump"}, method={RequestMethod.GET})
    public ModelAndView getVersionDump(HttpServletResponse httpServletResponse, WebRequest webRequest) {
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, null, this.servletContext);
        databaseWorker.saveVersionDumpInResponse(httpServletResponse);
        return new ModelAndView("redirect:/test.html");
    }

    @RequestMapping(value={"/delete/{version}"}, method={RequestMethod.POST})
    public ModelAndView deleteSchemaVersion(@PathVariable(value="version") String version, WebRequest webRequest) {
        SchemaVersion schemaVersion = this.schemeVersionService.findVersion(version);
        if (schemaVersion.getCurrent().booleanValue()) {
            return new ModelAndView("redirect:/test.html");
        }
        this.schemeVersionService.delete((Object)schemaVersion.getId());
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, schemaVersion, this.servletContext);
        databaseWorker.deleteVersion();
        return new ModelAndView("redirect:/test.html");
    }

    private SchemaVersion createCurrentVersion(String versionName, String description) {
        SchemaVersion currentVersion = this.schemeVersionService.findCurrentVersion();
        if (currentVersion != null) {
            currentVersion.setCurrent(Boolean.valueOf(false));
            this.schemeVersionService.save((Object)currentVersion);
        }
        SchemaVersion schemaVersion = new SchemaVersion();
        schemaVersion.setCurrent(Boolean.valueOf(true));
        schemaVersion.setVersion(versionName.substring(0, versionName.indexOf(".sql")));
        schemaVersion.setTimestamp(new Date());
        if (description != null) {
            schemaVersion.setDescription(description);
        }
        return (SchemaVersion)this.schemeVersionService.save((Object)schemaVersion);
    }
}

