/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.controllers.html.exceptions.NotFoundException;
import com.imcode.entities.Person;
import com.imcode.entities.Pupil;
import com.imcode.services.AcademicYearService;
import com.imcode.services.PersonService;
import com.imcode.services.PupilService;
import com.imcode.services.SchoolClassService;
import com.imcode.services.SchoolService;
import java.util.Locale;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/pupils"})
public class PupilController {
    public static final String MAIN_PATH = "pupils";
    @Autowired
    private PupilService mainService;
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private PersonService personService;
    @Autowired
    private SchoolClassService schoolClassService;
    @Autowired
    private AcademicYearService academicYearService;
    @Autowired
    MessageSource messageSource;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView list(ModelAndView model, Authentication authentication) {
        model.setViewName("pupils/list");
        model.addObject("entityList", (Object)this.mainService.findAll());
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.GET})
    public ModelAndView updateForm(@PathVariable(value="id") Pupil entity, ModelAndView model, WebRequest webRequest, Locale locale) {
        this.addSpecialObjects(model, entity);
        if (entity == null) {
            model.setViewName("pupils/list");
            throw new NotFoundException();
        }
        model.setViewName("pupils/edit");
        model.addObject("entity", (Object)entity);
        return model;
    }

    @RequestMapping(params={"form"}, method={RequestMethod.GET})
    public ModelAndView createForm(ModelAndView model) {
        Pupil entity = new Pupil();
        this.addSpecialObjects(model, entity);
        model.setViewName("pupils/edit");
        model.addObject("entity", (Object)entity);
        return model;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView create(@ModelAttribute(value="entity") @Valid Pupil entity, BindingResult bindingResultEntity, ModelAndView model, WebRequest webRequest, Locale locale) {
        this.addSpecialObjects(model, entity);
        if (bindingResultEntity.hasErrors()) {
            model.addObject("entity", (Object)entity);
            model.setViewName("pupils/edit");
            return model;
        }
        this.mainService.save((Object)entity);
        model.setViewName("redirect:/pupils");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    public ModelAndView update(@PathVariable(value="id") @ModelAttribute(value="entity") Pupil persistEntity, @ModelAttribute(value="entity") @Valid Pupil entity, BindingResult bindingResultEntity, ModelAndView model, WebRequest webRequest, Locale locale) {
        this.addSpecialObjects(model, entity);
        if (bindingResultEntity.hasErrors()) {
            model.addObject("entity", (Object)entity);
            model.setViewName("pupils/edit");
            return model;
        }
        if (persistEntity == null) {
            throw new NotFoundException();
        }
        Person persistPerson = persistEntity.getPerson();
        Person entityPerson = entity.getPerson();
        persistPerson.setPersonalId(entityPerson.getPersonalId());
        persistPerson.setFirstName(entityPerson.getFirstName());
        persistPerson.setLastName(entityPerson.getLastName());
        this.personService.save((Object)persistPerson);
        model.setViewName("redirect:/pupils");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable(value="id") Long id) {
        if (!this.mainService.exist((Object)id)) {
            throw new NotFoundException();
        }
        this.mainService.delete((Object)id);
    }

    protected void addSpecialObjects(ModelAndView model, Pupil entity) {
        model.addObject("schoolList", (Object)this.schoolService.findAll());
        model.addObject("schoolClassList", (Object)this.schoolClassService.findAll());
        model.addObject("academicYearList", (Object)this.academicYearService.findAll());
    }
}

