/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Incident;
import com.imcode.entities.Status;
import com.imcode.exceptions.MessagingException;
import com.imcode.services.IncidentService;
import com.imcode.services.StatusService;
import com.imcode.services.UserService;
import com.imcode.utils.StaticUtls;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}/incidents"})
public class IncidentRestControllerImpl
extends AbstractRestController<Incident, Long, IncidentService> {
    @Autowired
    IncidentService incidentService;
    @Autowired
    UserService userService;
    @Autowired
    StatusService statusService;

    @Override
    public Object create(@Validated @RequestBody Incident entity, WebRequest webRequest) throws MessagingException {
        try {
            entity.setReportDay(new Date());
            entity.setReportedBy(StaticUtls.getCurrentUser(webRequest, this.userService).getPerson());
            List statuses = this.statusService.findAll();
            entity.setStatus(statuses.stream().filter(status -> status.getName().equals((Object)Status.State.NEW)).findFirst().get());
            return super.create(entity, webRequest);
        }
        catch (Exception ex) {
            throw new MessagingException("Requested values conflict with DB", ex.getMessage());
        }
    }

    @RequestMapping(method={RequestMethod.GET}, params={"search_text", "order_by"})
    public Object findByCriteria(@RequestParam(value="search_text") String searchText, @RequestParam(value="order_by") String orderBy, WebRequest webRequest) {
        if (orderBy.equals("title")) {
            return this.incidentService.findBySearchCriteria(searchText, orderBy);
        }
        return null;
    }
}

