/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.controllers.html.EntityNotFoundException;
import com.imcode.controllers.html.RepositoryNotFoundException;
import com.imcode.entities.User;
import java.util.Locale;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import javax.validation.Valid;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/domain/{entityClassName}"})
public class DomainController {
    @Autowired
    private ApplicationContext applicationContext;
    private Repositories repositories;
    private RepositoryInvokerFactory repositoryInvokerFactory;
    private final int DEFAULT_PAGE_NUMBER = 1;
    private final int DEFAULT_PAGE_SIZE = 50;
    private final Sort DEFAULT_PAGE_SORT = new Sort(Sort.Direction.ASC, new String[]{"id"});
    private final Pageable DEFAULT_LIST_PAGE = new PageRequest(1, 50, this.DEFAULT_PAGE_SORT);
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private ConversionService conversionService;
    @Autowired
    MessageSource messageSource;

    @PostConstruct
    public void init() {
        this.repositories = new Repositories((ListableBeanFactory)this.applicationContext);
        this.repositoryInvokerFactory = new DefaultRepositoryInvokerFactory(this.repositories, this.conversionService);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView list(@PathVariable(value="entityClassName") String entityClassName, ModelAndView model, Authentication authentication) {
        EntityType entityType = this.getEntityType(entityClassName);
        if (entityType == null) {
            throw new EntityNotFoundException();
        }
        Class entityClass = entityType.getJavaType();
        RepositoryInvoker repositoryInvoker = this.repositoryInvokerFactory.getInvokerFor(entityClass);
        if (repositoryInvoker == null) {
            throw new RepositoryNotFoundException();
        }
        Iterable entities = repositoryInvoker.invokeFindAll(this.DEFAULT_PAGE_SORT);
        model.setViewName("domain/list/" + entityClassName.getClass().getSimpleName());
        model.getModelMap().clear();
        model.addObject("entities", (Object)entities);
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.GET})
    public ModelAndView updateForm(@PathVariable(value="id") User user, ModelAndView model, WebRequest webRequest, Locale locale) {
        return model;
    }

    @RequestMapping(params={"form"}, method={RequestMethod.GET})
    public ModelAndView createForm(ModelAndView model) {
        return model;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView create(@ModelAttribute(value="user") @Valid User user, BindingResult bindingResultUser, ModelAndView model, WebRequest webRequest, Locale locale) {
        model.setViewName("redirect:/users");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    public ModelAndView update(@PathVariable(value="id") User persistUser, @ModelAttribute(value="user") @Valid User user, BindingResult bindingResultUser, ModelAndView model, WebRequest webRequest, Locale locale) {
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable(value="id") Long id) {
    }

    private EntityType getEntityType(String className) {
        Set entitySet = this.entityManager.getMetamodel().getEntities();
        for (EntityType entityType : entitySet) {
            String entityClassName = entityType.getJavaType().getSimpleName();
            if (!className.equals(entityClassName)) continue;
            return entityType;
        }
        return null;
    }
}

