/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers;

import com.imcode.controllers.CrudController;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.exceptions.MessageOfException;
import com.imcode.exceptions.MessagingException;
import com.imcode.exceptions.ValidationError;
import com.imcode.exceptions.ValidationErrorBuilder;
import com.imcode.misc.errors.ErrorFactory;
import com.imcode.services.GenericService;
import com.imcode.services.NamedService;
import com.imcode.services.PersonalizedService;
import com.imcode.utils.StaticUtls;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.validation.Errors;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;

public abstract class AbstractRestController<T extends JpaEntity<ID>, ID extends Serializable, SERVICE_TYPE extends GenericService<T, ID>>
implements CrudController<T, ID> {
    @Autowired
    private SERVICE_TYPE service;
    @Autowired
    private ErrorFactory errorFactory;
    @Autowired
    private ApplicationContext ctx;

    @Override
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public Object get(@PathVariable(value="id") ID id, WebRequest webRequest) {
        return this.service.find(id);
    }

    @Override
    @RequestMapping(method={RequestMethod.GET})
    public Object getAll(WebRequest webRequest, Model model) {
        List result = this.service.findAll();
        return result;
    }

    @Override
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Object create(@RequestBody T entity, WebRequest webRequest) throws MessagingException {
        return this.service.save(entity);
    }

    @RequestMapping(value={"/bulk"}, method={RequestMethod.POST})
    @ResponseBody
    public Object sava(@RequestBody Iterable<T> entities, WebRequest webRequest, @RequestParam(required=false) Boolean full) {
        Iterable result = this.service.save(entities);
        if (Boolean.FALSE.equals(full)) {
            List ids = StreamSupport.stream(result.spliterator(), false).map(JpaEntity::getId).collect(Collectors.toList());
            return ids;
        }
        return result;
    }

    @Override
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public Object update(@PathVariable(value="id") ID id, @RequestBody(required=false) T entity, WebRequest webRequest) {
        JpaEntity existsEntity = (JpaEntity)this.getService().find(id);
        if (existsEntity != null) {
            try {
                StaticUtls.nullAwareBeanCopy(existsEntity, entity);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.service.save((Object)existsEntity);
        }
        return existsEntity;
    }

    @Override
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable(value="id") ID id, WebRequest webRequest) {
        this.service.delete(id);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"name"})
    public Object getByName(WebRequest webRequest, Model model, @RequestParam(value="name") String name, @RequestParam(value="first", required=false) Boolean firstOnly) {
        if (this.service instanceof NamedService) {
            NamedService namedService = (NamedService)this.service;
            if (firstOnly == null || !firstOnly.booleanValue()) {
                return namedService.findByName(name);
            }
            return namedService.findFirstByName(name);
        }
        throw new UnsupportedOperationException("findByName metod not supported!");
    }

    @RequestMapping(method={RequestMethod.GET}, params={"personalId"})
    public Object getByPersonalId(@RequestParam(value="personalId") String personId, @RequestParam(value="first", required=false) Boolean firstOnly) {
        if (this.service instanceof PersonalizedService) {
            PersonalizedService personalizedService = (PersonalizedService)this.service;
            if (firstOnly == null || !firstOnly.booleanValue()) {
                return personalizedService.findByPersonalId(personId);
            }
            return personalizedService.findFirstByPersonalId(personId);
        }
        throw new UnsupportedOperationException("findByName metod not supported!");
    }

    public SERVICE_TYPE getService() {
        return this.service;
    }

    public void setService(SERVICE_TYPE service) {
        this.service = service;
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ValidationError handleException(MethodArgumentNotValidException exception) {
        return this.createValidationError(exception);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public MessageOfException messagingException(MessagingException exception) {
        return exception.getExceptionMeassage();
    }

    private ValidationError createValidationError(MethodArgumentNotValidException e) {
        return ValidationErrorBuilder.fromBindingErrors((Errors)e.getBindingResult());
    }
}

