/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.security.interceptors;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.imcode.entities.User;
import com.imcode.exceptions.factories.ErrorBuilder;
import com.imcode.exceptions.wrappers.GeneralError;
import com.imcode.services.PermissionService;
import com.imcode.utils.StaticUtls;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AccessApiInterceptor
extends HandlerInterceptorAdapter {
    private final PermissionService permissionService;

    @Autowired
    public AccessApiInterceptor(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof OAuth2Authentication)) {
            response.setStatus(401);
            this.setErrorInResponse("Authorization without OAuth2 protocol.", response);
            return false;
        }
        OAuth2Authentication oauth2Authentication = (OAuth2Authentication)authentication;
        OAuth2Request clientAuthentication = oauth2Authentication.getOAuth2Request();
        String clientId = clientAuthentication.getClientId();
        Long userId = (Long)((User)oauth2Authentication.getUserAuthentication().getPrincipal()).getId();
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        String url = request.getRequestURI();
        url = url.replaceAll("/\\d+", "/{id}");
        String replacement = "/{format}/";
        url = url.replace("/json/", "/{format}/");
        url = url.replace("/xml/", "/{format}/");
        Integer hash = StaticUtls.getHashFrom(handlerMethod) + url.hashCode();
        Boolean permitted = this.permissionService.isPermitted(clientId, userId, hash);
        if (Objects.isNull(permitted)) {
            response.setStatus(403);
            this.setErrorInResponse("Client and/or user haven't permission to access " + handlerMethod.getBeanType().getSimpleName().replace("RestControllerImpl", "") + "[" + handlerMethod.getMethod().getName() + "] method.", response);
            return false;
        }
        return permitted;
    }

    private void setErrorInResponse(String message, HttpServletResponse response) throws IOException {
        GeneralError generalError = ErrorBuilder.buildSecurityException(message);
        String errorAsJson = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).writeValueAsString((Object)generalError);
        response.getOutputStream().print(errorAsJson);
    }
}

