/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Guardian;
import com.imcode.entities.Person;
import com.imcode.entities.Pupil;
import com.imcode.entities.User;
import com.imcode.services.GuardianService;
import com.imcode.services.PersonService;
import com.imcode.services.PupilService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}/pupils"})
public class PupilRestControllerImpl
extends AbstractRestController<Pupil, Long, PupilService> {
    @Autowired
    private GuardianService guardianService;
    @Autowired
    private PersonService personService;
    @Autowired
    private PupilService pupilService;

    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    public List<Pupil> getAllPupils(WebRequest webRequest, Model model) {
        return this.pupilService.findAll();
    }

    @Override
    public List<Pupil> getAll(WebRequest webRequest, HttpServletResponse response, Model model) {
        Guardian guardian;
        Person person;
        ArrayList<Pupil> pupilList = new ArrayList<Pupil>();
        User user = this.getUser(webRequest);
        if (user == null) {
            throw new RuntimeException("User unauthorized!");
        }
        if (user.hasRoles(new String[]{"ROLE_GUARDIAN"}) && (person = user.getPerson()) != null && (guardian = (Guardian)this.guardianService.findFirstByPersonalId(person.getPersonalId())) != null) {
            pupilList.addAll(guardian.getPupils());
        }
        return pupilList;
    }

    @Override
    @RequestMapping(method={RequestMethod.GET}, params={"personalId"})
    public List<Pupil> getByPersonalId(@RequestParam(value="personalId") String personId, HttpServletResponse response) throws Exception {
        return super.getByPersonalId(personId, response);
    }

    @Override
    @RequestMapping(method={RequestMethod.GET}, params={"personalId", "first"})
    public Pupil getFirstByPersonalId(@RequestParam(value="personalId") String personId, HttpServletResponse response) throws Exception {
        return (Pupil)super.getFirstByPersonalId(personId, response);
    }

    private User getUser(WebRequest webRequest) {
        User user = null;
        try {
            Authentication authentication = (Authentication)webRequest.getUserPrincipal();
            user = (User)authentication.getPrincipal();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return user;
    }
}

