/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.imcode.controllers.html.form.upload.FileOption;
import com.imcode.controllers.html.form.upload.FileUploadForm;
import com.imcode.controllers.html.form.upload.FileUploadOptionsForm;
import com.imcode.controllers.html.form.upload.loaders.EntityLoader;
import com.imcode.controllers.html.form.upload.loaders.LoaderService;
import com.imcode.entities.Person;
import com.imcode.misc.UploadFileManager;
import com.imcode.utils.StaticUtils;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/csv"})
public class CsvLoaderController {
    private static final String UPLOAD_FILE_MANAGER = "uploadFileManager";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean debug = false;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private LoaderService loaderService;
    private Map<Class<?>, Supplier<FieldSetMapper>> fieldSetMappers;

    @RequestMapping(method={RequestMethod.GET})
    public String step1() {
        return "csv/file_upload_step1";
    }

    @RequestMapping(value={"/step2"}, method={RequestMethod.POST})
    public String step2(@ModelAttribute(value="uploadForm") FileUploadForm uploadForm, Model model, HttpServletRequest request, Principal principal) {
        List<MultipartFile> files = uploadForm.getFiles();
        Map<Class, Set> typeMap = this.loaderService.stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((EntityLoader)entry.getValue()).getAllowedFieldSet()));
        Set mockEntityProperties = typeMap.get(Person.class);
        ArrayList<FileOption> fileOptionList = new ArrayList<FileOption>();
        FileUploadOptionsForm fileUploadOptionsForm = new FileUploadOptionsForm();
        fileUploadOptionsForm.setFileOptionList(fileOptionList);
        if (!files.stream().anyMatch(MultipartFile::isEmpty)) {
            UploadFileManager fileManager = this.getUploadFileManeger(request);
            HttpSession session = request.getSession(true);
            session.setAttribute(UPLOAD_FILE_MANAGER, (Object)fileManager);
            for (MultipartFile multipartFile : files) {
                FileOption fileOption = FileOption.of(null, multipartFile, 10);
                String fileId = fileManager.put(multipartFile);
                fileOption.setFileId(fileId);
                fileOptionList.add(fileOption);
            }
        } else {
            return "csv/file_upload_step1";
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String typeMapJson = null;
        try {
            typeMapJson = objectMapper.writeValueAsString(typeMap);
        }
        catch (JsonProcessingException e) {
            this.logger.warning(() -> ((JsonProcessingException)e).getMessage());
        }
        model.addAttribute("fileUploadOptionsForm", (Object)fileUploadOptionsForm);
        model.addAttribute("typeMap", typeMap);
        model.addAttribute("typeMapJson", (Object)typeMapJson);
        model.addAttribute("mockEntityProperties", (Object)mockEntityProperties);
        return "csv/file_upload_step2";
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    public String test(Model model, HttpServletRequest request, Principal principal) {
        FileUploadOptionsForm optionsForm = (FileUploadOptionsForm)StaticUtils.loadObjectFromFile((String)"test/");
        return this.step3(optionsForm, model, request, principal);
    }

    @RequestMapping(value={"/step3"}, method={RequestMethod.POST})
    public String step3(@ModelAttribute(value="fileUploadOptionsForm") FileUploadOptionsForm optionsForm, Model model, HttpServletRequest request, Principal principal) {
        UploadFileManager uploadFileManager = this.getUploadFileManeger(request);
        LinkedList resultList = new LinkedList();
        for (int i = 0; i < 2; ++i) {
            for (FileOption fileOption : optionsForm.getFileOptionList()) {
                ArrayList<Object> result = new ArrayList<Object>();
                resultList.add(result);
                String fileId = fileOption.getFileId();
                Path file = uploadFileManager.getFile(fileId);
                if (file == null || Files.notExists(file, new LinkOption[0])) {
                    throw new RuntimeException("file not found");
                }
                EntityLoader<?> entityLoader = this.loaderService.getLoader(fileOption.getType());
                if (entityLoader == null) {
                    throw new RuntimeException("loader not found");
                }
                FileSystemResource resource = new FileSystemResource(file.toFile());
                DelimitedLineTokenizer tokenizer = new DelimitedLineTokenizer();
                tokenizer.setNames(fileOption.getColumnNameList().toArray(new String[fileOption.getColumnNameList().size()]));
                FieldSetMapper<?> fieldMapper = entityLoader.getFieldSetMapper(fileOption);
                DefaultLineMapper lineMapper = new DefaultLineMapper();
                lineMapper.setLineTokenizer((LineTokenizer)tokenizer);
                lineMapper.setFieldSetMapper(fieldMapper);
                FlatFileItemReader itemReader = new FlatFileItemReader();
                itemReader.setResource((Resource)resource);
                itemReader.setLineMapper((LineMapper)lineMapper);
                itemReader.setLinesToSkip(fileOption.getSkipRows());
                itemReader.open(new ExecutionContext());
                try {
                    Object entity;
                    while ((entity = itemReader.read()) != null) {
                        result.add(entity);
                    }
                }
                catch (Exception e) {
                    this.logger.warning(e::getMessage);
                }
                ItemWriter<?> itemWriter = entityLoader.getItemWriter();
                try {
                    itemWriter.write(result);
                }
                catch (Exception e) {
                    this.logger.warning(e::getMessage);
                }
                fileOption.setResult(result);
            }
        }
        if (!this.debug) {
            for (FileOption fileOption : optionsForm.getFileOptionList()) {
                String fileId = fileOption.getFileId();
                uploadFileManager.delete(fileId);
            }
        }
        model.addAttribute("fileUploadOptionsForm", (Object)optionsForm);
        return "csv/file_upload_step3";
    }

    private UploadFileManager getUploadFileManeger(HttpServletRequest request) {
        UploadFileManager uploadFileManager = (UploadFileManager)request.getSession(true).getAttribute(UPLOAD_FILE_MANAGER);
        if (uploadFileManager == null) {
            uploadFileManager = new UploadFileManager(request.getUserPrincipal());
        }
        return uploadFileManager;
    }

    public static Set<String> getBeanFields(Class<?> clazz) {
        TreeSet<String> result = new TreeSet<String>();
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            Set fieldSet = Arrays.stream(fields).map(Field::getName).collect(Collectors.toSet());
            result.addAll(fieldSet);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Set<String> getBeanFieldsRecursively(Class<?> clazz, String prefix) {
        TreeSet<String> result = new TreeSet<String>();
        String string = prefix = prefix.length() == 0 ? prefix : prefix + ".";
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                String fieldName = prefix + field.getName();
                Class<?> fieldType = field.getType();
                result.add(fieldName);
                if (ClassUtils.isPrimitiveOrWrapper(fieldType)) continue;
                result.addAll(CsvLoaderController.getBeanFieldsRecursively(fieldType, fieldName));
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Set<String> getBeanFieldsRecursively(Class<?> clazz) {
        return CsvLoaderController.getBeanFieldsRecursively(clazz, "");
    }
}

