/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.entities.Permission;
import com.imcode.entities.superclasses.ContactInformation;
import com.imcode.search.SearchCriteries;
import com.imcode.services.PermissionService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ReflectionUtils;

public class DocumentationUtil {
    private final String ZIP_FILE_NAME = "/api_docs.zip";
    private final String SERVICE_FOLDER = "services/";
    private final String ENTITY_FOLDER = "entities/";
    private final String INFO_PROPERTIES = "/service.info.properties";
    private Properties properties;
    private Map<String, List<Permission>> groups;
    private Class<JsonIgnore> JSON_IGNORE_ANNOTATION = JsonIgnore.class;
    private ZipOutputStream zipOutputStream;
    private Set<String> setOfUsedClasses = new HashSet<String>();
    private String contactInformationType;
    public Logger logger = LoggerFactory.getLogger(this.getClass());

    public void generate(PermissionService permissionService, ServletContext servletContext) {
        this.properties = new Properties();
        try {
            this.properties.load(servletContext.getResourceAsStream("/WEB-INF/service.info.properties"));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e.getCause());
        }
        List allPermissions = permissionService.findAll();
        this.groups = new HashMap<String, List<Permission>>();
        File file = new File(servletContext.getRealPath("/") + "/api_docs.zip");
        if (file.exists()) {
            file.delete();
        }
        try {
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            this.logger.error(e.getMessage(), e.getCause());
        }
        allPermissions.forEach(this::separateOnGroups);
        this.groups.forEach(this::process);
        this.generateRelatedInfo();
        try {
            this.zipOutputStream.close();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e.getCause());
        }
    }

    private void separateOnGroups(Permission permission) {
        String entityName = permission.getEntityName();
        List<Permission> list = this.groups.get(entityName);
        if (list == null) {
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            permissions.add(permission);
            this.groups.put(entityName, permissions);
        } else {
            list.add(permission);
        }
    }

    private void process(String entityName, List<Permission> permissions) {
        List<Permission> sortedByMethodName = permissions.stream().sorted(Comparator.comparing(Permission::getMethodName)).collect(Collectors.toList());
        String inPlural = DocumentationUtil.toPluralForm(entityName);
        StringBuilder content = new StringBuilder();
        content.append(inPlural).append("\n").append(this.generateStringFromRepeating('=', inPlural.length())).append("\n").append("\n").append("``(implementation of ").append(entityName).append(" entity)``").append("\n").append("\n").append("Provides following method for `API <http://docs.ivis.se/en/latest/api/index.html>`_ calls:").append("\n").append("\n").append(this.generateMethodsNameList(sortedByMethodName)).append("\n").append("\n").append(this.generateMethodsInfo(sortedByMethodName));
        this.createZipEntry("services/" + this.toLowerCaseInPluralForm(entityName) + ".rst", content.toString());
    }

    private void createZipEntry(String name, String content) {
        ZipEntry entry = new ZipEntry(name);
        try {
            this.zipOutputStream.putNextEntry(entry);
            byte[] data = content.getBytes();
            this.zipOutputStream.write(data, 0, data.length);
            this.zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e.getCause());
        }
    }

    private void generateRelatedInfo() {
        HashSet all = new HashSet();
        HashSet<String> current = new HashSet<String>(this.setOfUsedClasses);
        while (this.setOfUsedClasses.size() > 0) {
            this.setOfUsedClasses = new HashSet<String>();
            current.forEach(usedClass -> this.process((String)usedClass, all));
            current = new HashSet<String>(this.setOfUsedClasses);
        }
    }

    private void process(String className, Set<String> all) {
        boolean add = all.add(className);
        if (add) {
            StringBuilder content = new StringBuilder();
            String simpleClassName = className.substring(className.lastIndexOf(46) + 1);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className.trim());
            }
            catch (ClassNotFoundException e) {
                this.logger.error(e.getMessage(), e.getCause());
            }
            assert (clazz != null);
            String prefix = "List of properties from ";
            content.append(prefix).append(simpleClassName).append('\n').append(this.generateStringFromRepeating('=', (prefix + simpleClassName).length()));
            if (clazz.isEnum()) {
                content.append('\n').append('\n').append("It is enum, that has STRING values.").append('\n').append('\n').append("Values:").append('\n').append("    ").append(this.genEnumList(clazz)).append(".");
            } else {
                content.append(this.genListOfReturnType(className.trim()));
            }
            this.createZipEntry("entities/" + simpleClassName + ".rst", content.toString());
        }
    }

    private String genEnumList(Class<?> clazz) {
        ?[] values = clazz.getEnumConstants();
        String prefixAndSuffix = "\"";
        return Arrays.stream(values).map(value -> {
            try {
                return (String)ReflectionUtils.invokeMethod((Method)clazz.getMethod("name", new Class[0]), (Object)value);
            }
            catch (ClassCastException | NoSuchMethodException e) {
                this.logger.error(e.getMessage(), e.getCause());
                return null;
            }
        }).map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
    }

    private String generateMethodsNameList(List<Permission> permissions) {
        String prefix = "    * `";
        String suffix = "`_";
        return permissions.stream().map(Permission::getMethodName).map(methodName -> prefix + StringUtils.capitalize((String)methodName) + suffix).collect(Collectors.joining("\n"));
    }

    private String generateMethodsInfo(List<Permission> sortedByMethodName) {
        return sortedByMethodName.stream().map(this::genMethodInfo).collect(Collectors.joining(""));
    }

    private String genMethodInfo(Permission permission) {
        String urlTitle = "URL:";
        String methodTitle = "Method:";
        String parametersRequestTitle = "Parameters request:";
        String parametersResponseTitle = "Parameters response:";
        StringBuilder methodInfo = new StringBuilder();
        String methodName = permission.getMethodName();
        String capitalize = StringUtils.capitalize((String)methodName);
        methodInfo.append(".. _`").append(StringUtils.capitalize((String)methodName)).append("`:").append("\n").append("\n").append(capitalize).append("\n").append(this.generateStringFromRepeating('-', capitalize.length())).append("\n").append("\n").append(urlTitle).append("\n").append(this.generateStringFromRepeating('~', urlTitle.length())).append("\n").append("    *").append(permission.getUrl()).append("*").append("\n").append("\n").append(methodTitle).append("\n").append(this.generateStringFromRepeating('~', methodTitle.length())).append("\n").append("    *").append(permission.getHttpMethod()).append("*").append("\n").append("\n").append(parametersRequestTitle).append("\n").append(this.generateStringFromRepeating('~', parametersRequestTitle.length())).append("\n").append(this.resolveParams(permission.getParameters())).append("\n").append("\n").append(parametersResponseTitle).append("\n").append(this.generateStringFromRepeating('~', parametersResponseTitle.length())).append("\n").append(this.resolveReturn(permission.getReturnValue()));
        String note = this.properties.getProperty(permission.getEntityName() + "." + permission.getMethodName());
        if (note != null) {
            methodInfo.append("\n").append(".. note::").append("\n").append("    ").append(note).append("\n").append("\n");
        }
        return methodInfo.toString();
    }

    private String resolveReturn(String returnValue) {
        StringBuilder responseInfo = new StringBuilder();
        return responseInfo.append("    *").append(returnValue.substring(0, returnValue.lastIndexOf(60))).append("*").append("\n").append("\n").append("    Description:").append("\n").append(this.genListOfReturnType(returnValue.substring(returnValue.lastIndexOf(60) + 1, returnValue.length() - 1))).append("\n").toString();
    }

    private String genListOfReturnType(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            return "        Starting downloading of file";
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return "        ARRAY<NUMBER>";
        }
        Map<String, String> fieldJsonType = new JsonFieldResolver(clazz).getFieldJsonType();
        StringBuilder fieldType = new StringBuilder("\n");
        fieldJsonType.forEach((name, type) -> fieldType.append("        #. ").append((String)name).append("(").append(this.mapType((String)type)).append(")").append("\n"));
        return fieldType.toString();
    }

    private String resolveParams(String parameters) {
        if (parameters == null) {
            return "    *null*";
        }
        String[] split = parameters.split(";");
        if (split.length == 2) {
            return "    " + split[0] + "\n\n    " + this.mapType(split[1].substring(1)) + "";
        }
        return "    " + this.mapType(split[0]);
    }

    private String mapType(String type) {
        if (!type.contains("<")) {
            return type;
        }
        String typeFullName = type.substring(type.lastIndexOf(60) + 1, type.lastIndexOf(62));
        if (!typeFullName.contains(".")) {
            return typeFullName;
        }
        if (typeFullName.contains(",")) {
            String[] split = typeFullName.split(",");
            return "KEY_ENUM_OBJECT_PAIR<" + split[0].replace(split[0], this.wrapType(split[0])) + ", " + split[1].replace(split[1], this.wrapType(split[1])).substring(1) + ">";
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(typeFullName);
        }
        catch (ClassNotFoundException e) {
            this.logger.error(e.getMessage(), e.getCause());
        }
        if (clazz != null) {
            if (clazz.equals(String.class)) {
                return type.replace(String.class.getTypeName(), "STRING");
            }
            if (clazz.equals(Class.class)) {
                return "STRING<ENTITY_CLASS_NAME>";
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return "NUMBER";
            }
        }
        return type.replace(typeFullName, this.wrapType(typeFullName));
    }

    private String wrapType(String typeFullName) {
        String prefix = "http://docs.ivis.se/en/latest/api/entities/";
        this.setOfUsedClasses.add(typeFullName);
        String simpleTypeName = typeFullName.substring(typeFullName.lastIndexOf(46) + 1);
        return " `" + simpleTypeName + " <" + prefix + simpleTypeName + ".html>`_ ";
    }

    public static String toPluralForm(String word) {
        StringBuilder modifiedEntityName = new StringBuilder(word);
        char lastLater = modifiedEntityName.charAt(modifiedEntityName.length() - 1);
        switch (lastLater) {
            case 'y': {
                modifiedEntityName.deleteCharAt(modifiedEntityName.length() - 1).append("ies");
                break;
            }
            case 's': {
                modifiedEntityName.append("es");
                break;
            }
            default: {
                modifiedEntityName.append('s');
            }
        }
        return modifiedEntityName.toString();
    }

    public static Set<Class<? extends Object>> getAllClassesFromPackage(String packageName) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(".*")));
        Set classes = provider.findCandidateComponents(packageName);
        Set<Class<? extends Object>> allClasses = classes.stream().map(bean -> {
            try {
                return Class.forName(bean.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(DocumentationUtil.class).error(e.getMessage(), e.getCause());
                return null;
            }
        }).collect(Collectors.toSet());
        return allClasses;
    }

    private String generateStringFromRepeating(char ch, int times) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    private String toLowerCaseInPluralForm(String str) {
        return DocumentationUtil.toPluralForm(str.toLowerCase());
    }

    private class JsonFieldResolver {
        private Map<String, String> fieldJsonType = new LinkedHashMap<String, String>();

        public JsonFieldResolver(Class<?> clazz) {
            if (ContactInformation.class.isAssignableFrom(clazz)) {
                DocumentationUtil.this.contactInformationType = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0].getTypeName();
            }
            ReflectionUtils.doWithFields(clazz, this::process);
        }

        public Map<String, String> getFieldJsonType() {
            return this.fieldJsonType;
        }

        private void process(Field field) {
            String PERSISTENCE_PACKAGE_NAME = "javax.persistence";
            boolean fieldAnnotated = field.getAnnotation(DocumentationUtil.this.JSON_IGNORE_ANNOTATION) != null;
            boolean getterAnnotated = false;
            Annotation[] annotations = field.getAnnotations();
            boolean isPersistenceField = Arrays.stream(annotations).anyMatch(annotation -> annotation.annotationType().getTypeName().startsWith("javax.persistence"));
            if (isPersistenceField) {
                try {
                    Method getter = field.getDeclaringClass().getMethod("get" + StringUtils.capitalize((String)field.getName()), new Class[0]);
                    getterAnnotated = getter.getAnnotation(DocumentationUtil.this.JSON_IGNORE_ANNOTATION) != null;
                }
                catch (NoSuchMethodException e) {
                    DocumentationUtil.this.logger.error(e.getMessage(), e.getCause());
                }
            }
            if (!fieldAnnotated && !getterAnnotated && isPersistenceField) {
                this.fieldJsonType.put(this.toSnackCaseFromCamelCase(field.getName()), this.resolveReturnType(field));
            } else if (field.getDeclaringClass().equals(SearchCriteries.SearchCriteriaResult.class)) {
                this.fieldJsonType.put(this.toSnackCaseFromCamelCase(field.getName()), this.resolveReturnType(field));
            }
        }

        private String resolveReturnType(Field field) {
            String TYPE_COLLECTION_OR_OBJECT;
            String typeName;
            String TYPE_NUMBER = "NUMBER";
            String TYPE_STRING = "STRING";
            String TYPE_BOOLEAN = "BOOLEAN";
            String TYPE_KEY_VALUE_PAIR = "KEY_VALUE_PAIR";
            String TYPE_ARRAY = "ARRAY";
            String TYPE_OBJECT = "OBJECT";
            Class<?> type = field.getType();
            if (type.equals(Serializable.class)) {
                return "NUMBER";
            }
            if (type.equals(Date.class)) {
                return "NUMBER(Date representation wrapped)";
            }
            if (Number.class.isAssignableFrom(type)) {
                return "NUMBER";
            }
            if (type.equals(String.class)) {
                return "STRING";
            }
            if (type.equals(Boolean.class)) {
                return "BOOLEAN";
            }
            if (DocumentationUtil.this.contactInformationType != null) {
                typeName = DocumentationUtil.this.contactInformationType;
                TYPE_COLLECTION_OR_OBJECT = "OBJECT";
                DocumentationUtil.this.contactInformationType = null;
            } else if (Map.class.isAssignableFrom(type)) {
                typeName = this.getTypeName(field, true);
                TYPE_COLLECTION_OR_OBJECT = "KEY_VALUE_PAIR";
            } else if (Collection.class.isAssignableFrom(type)) {
                typeName = this.getTypeName(field, false);
                TYPE_COLLECTION_OR_OBJECT = "ARRAY";
            } else {
                typeName = type.getTypeName();
                TYPE_COLLECTION_OR_OBJECT = "OBJECT";
            }
            return TYPE_COLLECTION_OR_OBJECT + "<" + typeName + ">";
        }

        private String toSnackCaseFromCamelCase(String str) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (Character.isUpperCase(ch)) {
                    stringBuilder.append('_');
                    stringBuilder.append(Character.toLowerCase(ch));
                    continue;
                }
                stringBuilder.append(ch);
            }
            return stringBuilder.toString();
        }

        private String getTypeName(Field field, boolean isMap) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            String typeName = genericType.getActualTypeArguments()[0].getTypeName();
            if (isMap) {
                typeName = typeName + ", " + genericType.getActualTypeArguments()[1].getTypeName();
            }
            return typeName;
        }
    }
}

