/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.saml2.utils;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.Configuration;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.decoding.HTTPPostDecoder;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.security.provider.BasicSecurityPolicy;
import org.opensaml.ws.security.provider.HTTPRule;
import org.opensaml.ws.security.provider.MandatoryIssuerRule;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLUtils {
    public static SAMLMessageContext decodeSamlMessage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        BasicSAMLMessageContext samlMessageContext = new BasicSAMLMessageContext();
        HttpServletRequestAdapter httpServletRequestAdapter = new HttpServletRequestAdapter(request);
        samlMessageContext.setInboundMessageTransport((InTransport)httpServletRequestAdapter);
        samlMessageContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        HttpServletResponseAdapter httpServletResponseAdapter = new HttpServletResponseAdapter(response, request.isSecure());
        samlMessageContext.setOutboundMessageTransport((OutTransport)httpServletResponseAdapter);
        samlMessageContext.setPeerEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        SecurityPolicyResolver securityPolicyResolver = SAMLUtils.getSecurityPolicyResolver(request.isSecure());
        samlMessageContext.setSecurityPolicyResolver(securityPolicyResolver);
        HTTPPostDecoder samlMessageDecoder = new HTTPPostDecoder();
        samlMessageDecoder.decode((MessageContext)samlMessageContext);
        return samlMessageContext;
    }

    private static SecurityPolicyResolver getSecurityPolicyResolver(boolean isSecured) {
        BasicSecurityPolicy securityPolicy = new BasicSecurityPolicy();
        HTTPRule httpRule = new HTTPRule(null, null, isSecured);
        MandatoryIssuerRule mandatoryIssuerRule = new MandatoryIssuerRule();
        List securityPolicyRules = securityPolicy.getPolicyRules();
        securityPolicyRules.add(httpRule);
        securityPolicyRules.add(mandatoryIssuerRule);
        return new StaticSecurityPolicyResolver((SecurityPolicy)securityPolicy);
    }

    public static String SAMLObjectToString(XMLObject samlObject) {
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(samlObject);
            Element authDOM = marshaller.marshall(samlObject);
            StringWriter rspWrt = new StringWriter();
            XMLHelper.writeNode((Node)authDOM, (Writer)rspWrt);
            return rspWrt.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

