/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Person;
import com.imcode.entities.PersonRole;
import com.imcode.entities.School;
import com.imcode.search.SearchCriteries;
import com.imcode.services.PersonRoleService;
import com.imcode.services.SchoolService;
import com.imcode.utils.StaticUtls;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}"})
public class SchoolRestControllerImpl
extends AbstractRestController<School, Long, SchoolService> {
    private static final String PATH_PLURAL = "/schools";
    private static final String PATH_SINGLE = "/school";
    private final PersonRoleService personRoleService;

    @Autowired
    public SchoolRestControllerImpl(PersonRoleService personRoleService) {
        this.personRoleService = personRoleService;
    }

    @Override
    @RequestMapping(value={"/schools"}, method={RequestMethod.GET}, params={"name"})
    public List<School> getByName(WebRequest webRequest, Model model, HttpServletResponse response, @RequestParam(value="name") String name) throws Exception {
        return super.getByName(webRequest, model, response, name);
    }

    @Override
    @RequestMapping(value={"/school"}, method={RequestMethod.GET}, params={"name", "first"})
    public School getFirstByName(WebRequest webRequest, Model model, HttpServletResponse response, @RequestParam(value="name") String name) throws Exception {
        return (School)super.getFirstByName(webRequest, model, response, name);
    }

    @Override
    @RequestMapping(value={"/school/{id}"}, method={RequestMethod.GET})
    public School get(@PathVariable(value="id") Long aLong, HttpServletResponse response, WebRequest webRequest) throws Exception {
        return (School)super.get(aLong, response, webRequest);
    }

    @Override
    @RequestMapping(value={"/schools"}, method={RequestMethod.GET})
    public List<School> getAll(WebRequest webRequest, HttpServletResponse response, Model model) throws Exception {
        return super.getAll(webRequest, response, model);
    }

    @Override
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(value={"/school"}, method={RequestMethod.POST})
    @ResponseBody
    public School create(@RequestBody @Valid School entity, HttpServletResponse response, BindingResult bindingResult, WebRequest webRequest) throws Exception {
        return super.create(entity, response, bindingResult, webRequest);
    }

    @Override
    @RequestMapping(value={"/schools/saveall"}, method={RequestMethod.POST})
    @ResponseBody
    public Iterable<School> saveAll(@RequestBody Iterable<School> entities, HttpServletResponse response, WebRequest webRequest) throws Exception {
        return super.saveAll(entities, response, webRequest);
    }

    @Override
    @RequestMapping(value={"/schools/saveall"}, method={RequestMethod.POST}, params={"full"})
    @ResponseBody
    public List<Long> saveAllAndReturnIds(@RequestBody Iterable<School> entities, HttpServletResponse response, WebRequest webRequest) throws Exception {
        return super.saveAllAndReturnIds(entities, response, webRequest);
    }

    @Override
    @RequestMapping(value={"/school/{id}"}, method={RequestMethod.PUT})
    public School update(@PathVariable(value="id") Long aLong, HttpServletResponse response, School entity, BindingResult bindingResult, WebRequest webRequest) throws Exception {
        return super.update(aLong, response, entity, bindingResult, webRequest);
    }

    @Override
    @RequestMapping(value={"/school/{id}"}, method={RequestMethod.DELETE})
    public School delete(@PathVariable(value="id") Long aLong, HttpServletResponse response, WebRequest webRequest) throws Exception {
        return (School)super.delete(aLong, response, webRequest);
    }

    @Override
    @RequestMapping(value={"/schools/search"}, method={RequestMethod.POST})
    @ResponseBody
    public List<School> search(@RequestBody List<SearchCriteries.SearchCriteriaResult> criteries) throws Exception {
        return super.search(criteries);
    }

    @Override
    @RequestMapping(value={"/school/search"}, method={RequestMethod.POST})
    public School searchFirst(@RequestBody List<SearchCriteries.SearchCriteriaResult> criteries) throws Exception {
        return (School)super.searchFirst(criteries);
    }

    @Override
    @RequestMapping(value={"/schools"}, method={RequestMethod.DELETE}, params={"ids"})
    @ResponseBody
    public List<School> deleteByIds(@RequestParam(value="ids") List<Long> longs, HttpServletResponse response, WebRequest webRequest) throws Exception {
        return super.deleteByIds(longs, response, webRequest);
    }

    @RequestMapping(value={"/school/{id}/persons"}, method={RequestMethod.GET})
    public List<Person> getPersonsBySchool(@PathVariable(value="id") Long aLong, HttpServletResponse response, WebRequest webRequest) throws Exception {
        List workRoles = this.personRoleService.findBySchool((School)super.get(aLong, response, webRequest));
        return StaticUtls.mapByRuleAndGetDistinct(workRoles, PersonRole::getPerson);
    }
}

