/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.entities.embed.Email;
import com.imcode.entities.enums.CommunicationTypeEnum;
import com.imcode.services.RoleService;
import com.imcode.services.UserService;
import com.imcode.utils.MailSenderUtil;
import com.imcode.utils.StaticUtls;
import com.imcode.validators.GeneralValidator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/users"})
public class UserController {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="${mail.smtp.from.address}")
    private String fromAddress;
    @Value(value="${mail.smtp.from.username}")
    private String fromUsername;
    private static final String ROLE_USER = "ROLE_USER";

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView list(ModelAndView model) {
        model.setViewName("users/list");
        model.addObject((Object)this.userService.findAll());
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.GET})
    public ModelAndView updateForm(@PathVariable(value="id") User user, ModelAndView model, WebRequest webRequest) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(user, "Try invoke update form for non exist user");
        User currentUser = StaticUtls.getCurrentUser(webRequest, this.userService);
        if (!currentUser.hasRoles(new String[]{"ROLE_ADMIN"}) && !((Long)user.getId()).equals(currentUser.getId())) {
            model.setViewName("redirect:/");
            return model;
        }
        model.setViewName("users/edit");
        model.addObject((Object)user);
        model.addObject(this.roleService.findUserRoles());
        return model;
    }

    @RequestMapping(params={"form"}, method={RequestMethod.GET})
    public ModelAndView createForm(ModelAndView model) {
        model.setViewName("users/edit");
        model.addObject(this.roleService.findUserRoles());
        User user = new User();
        Role roleUser = (Role)this.roleService.findFirstByName(ROLE_USER);
        model.addObject((Object)user);
        if (roleUser != null) {
            user.setAuthorities(roleUser);
        }
        return model;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView create(@ModelAttribute(value="user") @Valid User user, BindingResult bindingResult, ModelAndView model) throws MethodArgumentNotValidException {
        HashMap<String, Map<GeneralValidator.Constraint, String>> constraints = new HashMap<String, Map<GeneralValidator.Constraint, String>>();
        if (this.userService.findByUsername(user.getUsername()) != null) {
            bindingResult.reject(null, "username not unique");
        }
        new GeneralValidator(constraints).invoke(user, bindingResult);
        user.getRoles().add(this.roleService.findFirstByName(ROLE_USER));
        StaticUtls.encodeUserPassword(user);
        this.userService.save((Object)user);
        model.setViewName("redirect:/users");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    public ModelAndView update(@PathVariable(value="id") User persistUser, @ModelAttribute(value="user") User user, ModelAndView model) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(user, "Try update non exist user");
        if (user.getPassword().isEmpty()) {
            user.setPassword(persistUser.getPassword());
        } else {
            StaticUtls.encodeUserPassword(user);
        }
        Set internalRoles = persistUser.getRoles().stream().filter(Role::getInternal).collect(Collectors.toSet());
        internalRoles.add(this.roleService.findFirstByName(ROLE_USER));
        user.getRoles().addAll(internalRoles);
        try {
            StaticUtls.nullAwareBeanCopy(persistUser, user);
        }
        catch (Exception e) {
            this.logger.error("Error UserController.update", (Throwable)e);
        }
        this.userService.save((Object)persistUser);
        model.setViewName("redirect:/users");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable(value="id") Long id) throws MethodArgumentNotValidException {
        User user = (User)this.userService.find((Object)id);
        StaticUtls.rejectNullValue(user, "Try delete non exist user");
        this.userService.delete((Object)id);
    }

    @RequestMapping(value={"/{id}"}, params={"passwordchange"}, method={RequestMethod.POST})
    public ModelAndView passwordChange(@PathVariable(value="id") User user, @RequestParam(value="password") String password, ModelAndView model) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(user, "Try change password for non exist user");
        user.setPassword(password);
        StaticUtls.encodeUserPassword(user);
        this.userService.save((Object)user);
        String to = ((Email)user.getPerson().getEmails().get(CommunicationTypeEnum.HOME)).getValue();
        String subject = "Change password in iVIS";
        String text = "Hello, " + user.getUsername() + ". Your password has bean changed.";
        MailSenderUtil mailSenderUtil = new MailSenderUtil(this.mailSender, false, false, this.fromAddress, this.fromUsername);
        mailSenderUtil.createMessage(to, subject, text);
        mailSenderUtil.sendMessage();
        model.setViewName("redirect:/logout.do");
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"checkpassword"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean checkPassword(@PathVariable(value="id") User user, @RequestParam(value="checkpassword") String password) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(user, "Try check password for non exist user");
        String userEncodedPassword = user.getPassword();
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        return encoder.matches((CharSequence)password, userEncodedPassword);
    }
}

