/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.imcode.entities.User;
import com.imcode.entities.superclasses.AbstractIdEntity;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="dbo_once_time_access_token")
public class OnceTimeAccessToken
extends AbstractIdEntity<Long>
implements Serializable {
    @Column
    private String token;
    @Column(name="not_persist_user")
    @Lob
    private Serializable user;
    @Column(name="expiry_day")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date expiryDate;
    @Column(name="token_type")
    @Enumerated(value=EnumType.STRING)
    private TokenType tokenType;
    @Column
    private Boolean used = false;

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Serializable getUser() {
        return this.user;
    }

    public void setUser(Serializable user) {
        this.user = user;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public Boolean getUsed() {
        return this.used;
    }

    public void setUsed(Boolean used) {
        this.used = used;
    }

    public static OnceTimeAccessToken genToken(User user, int expiration, TokenType type) {
        OnceTimeAccessToken token = new OnceTimeAccessToken();
        token.setToken(UUID.randomUUID().toString());
        token.setUser((Serializable)user);
        token.setExpiryDate(OnceTimeAccessToken.calculateExpiryDate(expiration));
        token.setTokenType(type);
        return token;
    }

    private static Date calculateExpiryDate(int expiryTimeInMinutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Timestamp(cal.getTime().getTime()));
        cal.add(12, expiryTimeInMinutes);
        return new Date(cal.getTime().getTime());
    }

    public boolean isExpired() {
        return new Date().after(this.expiryDate);
    }

    public static enum TokenType {
        VERIFICATION("Verification token"),
        PASSWORD_RESET("Password reset token");

        private final String description;

        private TokenType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

