/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html.oauth2;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class IvisLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private static final String STANDARD_TARGET_URL = "/login";
    final TokenStore tokenStore;

    @Autowired
    public IvisLogoutSuccessHandler(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String redirectUrl = request.getParameter("redirect_url");
        if (redirectUrl == null) {
            redirectUrl = STANDARD_TARGET_URL;
        } else if (!redirectUrl.matches("(\\s*|^)(((ht|f)tp(s?)://(www)?)|www)((?:[a-z0-9.-]|%[0-9A-F]{2}){3,})(?::(\\d+))?((?:\\/(?:[a-z0-9-._~!$&'()*+,;=:@]|%[0-9A-F]{2})*)*)(?:\\?((?:[a-z0-9-._~!$&'()*+,;=:\\/?@]|%[0-9A-F]{2})*))?(?:#((?:[a-z0-9-._~!$&'()*+,;=:\\/?@]|%[0-9A-F]{2})*))?(\\s*|$)")) {
            redirectUrl = STANDARD_TARGET_URL;
        }
        if (authentication instanceof OAuth2Authentication) {
            OAuth2AccessToken accessToken = this.tokenStore.getAccessToken((OAuth2Authentication)authentication);
            this.tokenStore.removeAccessToken(accessToken);
        }
        this.setDefaultTargetUrl(redirectUrl);
        super.onLogoutSuccess(request, response, authentication);
    }
}

