/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.enums.AuthorizedGrantType;
import com.imcode.entities.oauth2.JpaClientDetails;
import com.imcode.oauth2.IvisClientDetailsService;
import com.imcode.services.RoleService;
import com.imcode.services.UserService;
import com.imcode.utils.StaticUtls;
import com.imcode.validators.GeneralValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/clients"})
public class ClientDetailsController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IvisClientDetailsService clientDetailsService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;

    @RequestMapping(method={RequestMethod.GET})
    public String getAll(Model model) {
        this.logger.info("Listing clients");
        List<Object> clientDetailsList = Collections.emptyList();
        clientDetailsList = this.clientDetailsService.findAll();
        model.addAttribute("clients", clientDetailsList);
        this.logger.info("No. of clients: " + clientDetailsList.size());
        return "clients/list";
    }

    @RequestMapping(value={"/{clientId}"}, method={RequestMethod.POST})
    public ModelAndView update(@PathVariable(value="clientId") String clientId, @ModelAttribute(value="client") @Valid JpaClientDetails client, BindingResult bindingResult, ModelAndView model) throws MethodArgumentNotValidException {
        JpaClientDetails persistentClient = this.clientDetailsService.findOne(clientId);
        StaticUtls.rejectNullValue(persistentClient, "Try update non exist client");
        new GeneralValidator(true, "autoApproveScopes").invoke(client, bindingResult);
        BeanUtils.copyProperties((Object)client, (Object)persistentClient, (String[])new String[]{"id", "autoApproveScopes"});
        client.addAuthorizedGrantType(AuthorizedGrantType.refresh_token);
        this.clientDetailsService.updateClientDetails(persistentClient);
        model.setViewName("redirect:/clients");
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.GET})
    public ModelAndView updateForm(@PathVariable(value="id") String id, ModelAndView model) throws MethodArgumentNotValidException {
        JpaClientDetails clientDetails = this.clientDetailsService.findOne(id);
        StaticUtls.rejectNullValue(clientDetails, "Try invoke update form for non exist client");
        this.addListsInModel(model);
        model.addObject("client", (Object)clientDetails);
        model.setViewName("clients/edit");
        return model;
    }

    @RequestMapping(params={"form"}, method={RequestMethod.GET})
    public ModelAndView createForm(ModelAndView model) {
        this.addListsInModel(model);
        JpaClientDetails client = new JpaClientDetails();
        model.addObject("client", (Object)client);
        model.setViewName("clients/edit");
        return model;
    }

    private void addListsInModel(ModelAndView model) {
        model.addObject(this.roleService.findClientRoles());
        model.addObject("grantTypes", Arrays.asList(AuthorizedGrantType.getRepresentations()));
    }

    @RequestMapping(method={RequestMethod.POST})
    public String create(@ModelAttribute(value="client") @Valid JpaClientDetails client, Model uiModel, RedirectAttributes redirectAttributes) {
        client.addAuthorizedGrantType(AuthorizedGrantType.refresh_token);
        this.clientDetailsService.addClientDetails(client);
        return "redirect:/clients";
    }

    @RequestMapping(value={"/{id}"}, params={"delete"}, method={RequestMethod.GET})
    public ModelAndView deleteClient(@PathVariable(value="id") String id, ModelAndView model) throws MethodArgumentNotValidException {
        JpaClientDetails clientDetails = this.clientDetailsService.findOne(id);
        StaticUtls.rejectNullValue(clientDetails, "Try delete non exist client");
        this.clientDetailsService.removeClientDetails(id);
        model.setViewName("redirect:/clients");
        return model;
    }
}

