/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.misc;

import java.lang.reflect.Method;
import java.util.function.Predicate;

class MutablePropertyFilter
implements Predicate<Method> {
    private final Class<?> beanType;

    MutablePropertyFilter(Class<?> beanType) {
        this.beanType = beanType;
    }

    @Override
    public boolean test(Method method) {
        String methodName = method.getName();
        if (!methodName.startsWith("get")) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.class) {
            return false;
        }
        String setterName = "s" + methodName.substring(1);
        try {
            this.beanType.getMethod(setterName, returnType);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }
}

