/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Person;
import com.imcode.entities.PersonRole;
import com.imcode.entities.School;
import com.imcode.entities.SchoolClass;
import com.imcode.entities.WorkRole;
import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.search.SearchCriteries;
import com.imcode.services.PersonRoleService;
import com.imcode.services.PersonService;
import com.imcode.services.UserService;
import com.imcode.utils.StaticUtls;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}"})
public class PersonRestControllerImpl
extends AbstractRestController<Person, Long, PersonService> {
    private final UserService userService;
    private final PersonRoleService personRoleService;
    private static final String PATH_PLURAL = "/persons";
    private static final String PATH_SINGLE = "/person";
    private static final Long CURRENT_FLAG = Long.MIN_VALUE;

    @Autowired
    public PersonRestControllerImpl(UserService userService, PersonRoleService personRoleService) {
        this.userService = userService;
        this.personRoleService = personRoleService;
    }

    @RequestMapping(value={"/persons"}, method={RequestMethod.GET}, params={"search_text", "order_by"})
    public List<Person> findByCriteria(@RequestParam(value="search_text") String searchText, @RequestParam(value="order_by") String orderBy, HttpServletResponse response, WebRequest webRequest) {
        if (orderBy.equals("last_name") || orderBy.equals("first_name")) {
            String validateOrderBy = orderBy.replace("_n", "N");
            return ((PersonService)this.getService()).findBySearchCriteria(searchText, validateOrderBy);
        }
        return null;
    }

    @Override
    @RequestMapping(value={"/persons"}, method={RequestMethod.GET}, params={"personalId"})
    public List<Person> getByPersonalId(@RequestParam(value="personalId") String personId, HttpServletResponse response) throws Exception {
        return super.getByPersonalId(personId, response);
    }

    @Override
    @RequestMapping(value={"/persons"}, method={RequestMethod.GET}, params={"personalId", "first"})
    public Person getFirstByPersonalId(@RequestParam(value="personalId") String personId, HttpServletResponse response) throws Exception {
        return (Person)super.getFirstByPersonalId(personId, response);
    }

    @Override
    @RequestMapping(value={"/persons"}, method={RequestMethod.GET})
    public List<Person> getAll(WebRequest webRequest, HttpServletResponse response, Model model) throws Exception {
        return super.getAll(webRequest, response, model);
    }

    @Override
    @RequestMapping(value={"/persons"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Person create(@RequestBody @Valid Person entity, HttpServletResponse response, BindingResult bindingResult, WebRequest webRequest) throws Exception {
        return super.create(entity, response, bindingResult, webRequest);
    }

    @Override
    @RequestMapping(value={"/persons/saveall"}, method={RequestMethod.POST})
    public Iterable<Person> saveAll(@RequestBody Iterable<Person> entities, HttpServletResponse response, WebRequest webRequest) throws Exception {
        return super.saveAll(entities, response, webRequest);
    }

    @Override
    @RequestMapping(value={"/persons/saveall"}, method={RequestMethod.POST}, params={"full"})
    public List<Long> saveAllAndReturnIds(@RequestBody Iterable<Person> entities, HttpServletResponse response, WebRequest webRequest) throws Exception {
        return super.saveAllAndReturnIds(entities, response, webRequest);
    }

    @Override
    @RequestMapping(value={"/persons/{id}"}, method={RequestMethod.PUT})
    public Person update(@PathVariable(value="id") Long aLong, HttpServletResponse response, Person entity, BindingResult bindingResult, WebRequest webRequest) throws Exception {
        return super.update(aLong, response, entity, bindingResult, webRequest);
    }

    @Override
    @RequestMapping(value={"/persons/{id}"}, method={RequestMethod.DELETE})
    public Person delete(@PathVariable(value="id") Long aLong, HttpServletResponse response, WebRequest webRequest) throws Exception {
        return (Person)super.delete(aLong, response, webRequest);
    }

    @Override
    @RequestMapping(value={"/persons/search"}, method={RequestMethod.POST})
    public List<Person> search(@RequestBody List<SearchCriteries.SearchCriteriaResult> criteries) throws Exception {
        return super.search(criteries);
    }

    @Override
    @RequestMapping(value={"/persons/search/first"}, method={RequestMethod.POST})
    public Person searchFirst(@RequestBody List<SearchCriteries.SearchCriteriaResult> criteries) throws Exception {
        return (Person)super.searchFirst(criteries);
    }

    @Override
    @RequestMapping(value={"/persons"}, method={RequestMethod.DELETE}, params={"ids"})
    public List<Person> deleteByIds(@RequestParam(value="ids") List<Long> longs, HttpServletResponse response, WebRequest webRequest) throws Exception {
        return super.deleteByIds(longs, response, webRequest);
    }

    @Override
    @RequestMapping(value={"/person/{id}"}, method={RequestMethod.GET})
    public Person get(@PathVariable(value="id") Long id, HttpServletResponse response, WebRequest webRequest) throws Exception {
        return (Person)super.get(id, response, webRequest);
    }

    @RequestMapping(value={"/person/current"}, method={RequestMethod.GET})
    public Person getCurrentPerson(WebRequest webRequest) {
        return StaticUtls.getCurrentUser(webRequest, this.userService).getPerson();
    }

    @RequestMapping(value={"/person/current/personroles"}, method={RequestMethod.GET})
    public List<PersonRole> getPersonRolesOfCurrentPerson(WebRequest webRequest) {
        return this.getPersonRoles(CURRENT_FLAG, webRequest);
    }

    @RequestMapping(value={"/person/{id}/personroles"}, method={RequestMethod.GET})
    public List<PersonRole> getPersonRolesByPerson(@PathVariable(value="id") Long id, WebRequest webRequest) {
        return this.getPersonRoles(id, webRequest);
    }

    @RequestMapping(value={"/person/current/schools"}, method={RequestMethod.GET})
    public List<School> getSchoolsOfCurrentPerson(WebRequest webRequest) {
        return this.getDistinctItemsOfPerson(CURRENT_FLAG, webRequest, PersonRole::getSchool);
    }

    @RequestMapping(value={"/person/{id}/schools"}, method={RequestMethod.GET})
    public List<School> getSchoolsByPerson(@PathVariable(value="id") Long id, WebRequest webRequest) {
        return this.getDistinctItemsOfPerson(id, webRequest, PersonRole::getSchool);
    }

    @RequestMapping(value={"/person/current/schoolclasses"}, method={RequestMethod.GET})
    public List<SchoolClass> getSchoolClassesOfCurrentPerson(WebRequest webRequest) {
        return this.getDistinctItemsOfPerson(CURRENT_FLAG, webRequest, PersonRole::getSchoolClass);
    }

    @RequestMapping(value={"/person/{id}/schoolclasses"}, method={RequestMethod.GET})
    public List<SchoolClass> getSchoolClassesByPerson(@PathVariable(value="id") Long id, WebRequest webRequest) {
        return this.getDistinctItemsOfPerson(id, webRequest, PersonRole::getSchoolClass);
    }

    @RequestMapping(value={"/person/current/workroles"}, method={RequestMethod.GET})
    public List<WorkRole> getWorkRolesOfCurrentPerson(WebRequest webRequest) {
        return this.getDistinctItemsOfPerson(CURRENT_FLAG, webRequest, PersonRole::getRole);
    }

    @RequestMapping(value={"/person/{id}/workroles"}, method={RequestMethod.GET})
    public List<WorkRole> getWorkRolesByPerson(@PathVariable(value="id") Long id, WebRequest webRequest) {
        return this.getDistinctItemsOfPerson(id, webRequest, PersonRole::getRole);
    }

    private List<PersonRole> getPersonRoles(Long id, WebRequest webRequest) {
        Person person = id.equals(CURRENT_FLAG) ? this.getCurrentPerson(webRequest) : (Person)((PersonService)this.getService()).find((Object)id);
        return this.personRoleService.findByPerson(person);
    }

    private <T extends AbstractIdEntity<Long>> List<T> getDistinctItemsOfPerson(Long id, WebRequest webRequest, Function<PersonRole, T> t) {
        HashMap distinct = new HashMap();
        this.getPersonRoles(id, webRequest).stream().map(t).forEach(item -> distinct.putIfAbsent(item.getId(), item));
        return new ArrayList(distinct.values());
    }
}

