/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.search.SearchCriteria;
import com.imcode.search.SearchCriteries;
import com.imcode.services.GenericService;
import com.imcode.specifications.JpaEntitySpecification;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractService<T extends JpaEntity, ID extends Serializable, REPOSITORY_TYPE extends JpaRepository<T, ID> & JpaSpecificationExecutor<T>>
implements GenericService<T, ID> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="messages")
    protected MessageSource messageSource;
    @Autowired
    protected REPOSITORY_TYPE repo;

    @Transactional
    public T save(T entity) {
        return (T)((JpaEntity)this.repo.saveAndFlush(entity));
    }

    @Transactional(readOnly=true)
    public T find(ID id) {
        return (T)((JpaEntity)this.repo.findOne(id));
    }

    public boolean exist(ID id) {
        return this.repo.exists(id);
    }

    @Transactional
    public void delete(ID id) {
        this.repo.delete(id);
    }

    @Transactional(readOnly=true)
    public List<T> findAll() {
        return this.repo.findAll();
    }

    @Transactional
    public T saveWithoutFlush(T entity) {
        return (T)((JpaEntity)this.repo.save(entity));
    }

    @Transactional
    public void flush() {
        this.repo.flush();
    }

    @Transactional
    public Iterable<T> save(Iterable<T> entities) {
        return this.repo.save(entities);
    }

    @Transactional
    public void delete(Iterable<T> entities) {
        this.repo.delete(entities);
    }

    public List<T> search(List<SearchCriteries.SearchCriteriaResult> criteries) {
        Specification<T> resultSpec;
        SearchCriteries.SearchCriteriaResult first = criteries.get(0);
        Sort sort = null;
        if (first.getOrderBy() != null && !first.getOrderBy().isEmpty() && first.getOrder() != null) {
            sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.fromString((String)first.getOrder().toString()), first.getOrderBy())});
        }
        if ((resultSpec = this.getResultSpec(criteries)) == null) {
            return null;
        }
        return sort == null ? this.findAll(resultSpec) : this.findAll(resultSpec, sort);
    }

    public T searchOne(List<SearchCriteries.SearchCriteriaResult> criteries) {
        Specification<T> resultSpec = this.getResultSpec(criteries);
        return resultSpec == null ? null : (T)this.findOne(resultSpec);
    }

    @Transactional
    private List<T> findAll(Specification<T> specification) {
        return ((JpaSpecificationExecutor)this.repo).findAll(specification);
    }

    @Transactional
    private List<T> findAll(Specification<T> specification, Sort sort) {
        return ((JpaSpecificationExecutor)this.repo).findAll(specification, sort);
    }

    @Transactional
    private T findOne(Specification<T> specification) {
        return (T)((JpaEntity)((JpaSpecificationExecutor)this.repo).findOne(specification));
    }

    public REPOSITORY_TYPE getRepo() {
        return this.repo;
    }

    public void setRepo(REPOSITORY_TYPE repo) {
        this.repo = repo;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    private JpaEntitySpecification<T> createSpec(List<SearchCriteries.SearchCriteriaResult> criteriaResults, int index) {
        try {
            SearchCriteries.SearchCriteriaResult criteriaResult = criteriaResults.get(index);
            String valueJson = criteriaResult.getValue();
            Object object = criteriaResult.getValueType().cast(new ObjectMapper().readValue(valueJson, criteriaResult.getValueType()));
            SearchCriteria searchCriteria = new SearchCriteria(criteriaResult.getFieldName(), criteriaResult.getOperation(), object);
            return new JpaEntitySpecification(searchCriteria);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getCause());
        }
    }

    private Specification<T> getResultSpec(List<SearchCriteries.SearchCriteriaResult> criteries) {
        if (criteries == null || criteries.isEmpty()) {
            return null;
        }
        SearchCriteries.SearchCriteriaResult first = criteries.get(0);
        Specifications resultSpec = this.createSpec(criteries, 0);
        Boolean isNextConditionAnd = first.getNextAnd();
        for (int i = 1; i < criteries.size(); ++i) {
            resultSpec = isNextConditionAnd != false ? Specifications.where(resultSpec).and(this.createSpec(criteries, i)) : Specifications.where(resultSpec).or(this.createSpec(criteries, i));
            isNextConditionAnd = criteries.get(i).getNextAnd();
        }
        return resultSpec;
    }
}

