/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.misc;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.web.multipart.MultipartFile;

public class UploadFileManager
implements Serializable {
    private final Path tempFilePath;
    private final Map<String, Path> files = new HashMap<String, Path>();

    public UploadFileManager() {
        this(null);
    }

    public UploadFileManager(Principal user) {
        String userPathName = user == null ? "Anonimus" : user.getName();
        this.tempFilePath = Paths.get("upload/" + userPathName, new String[0]);
        if (!Files.exists(this.tempFilePath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.tempFilePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }
    }

    public String put(MultipartFile multipartFile) {
        Path file = null;
        try {
            file = Files.createTempFile(this.tempFilePath, "", "", new FileAttribute[0]);
            multipartFile.transferTo(file.toFile());
        }
        catch (IOException e) {
            this.handleException(e);
        }
        if (file != null) {
            String id = file.getFileName().toString();
            if (this.files.containsKey(id)) {
                throw new RuntimeException("file \"" + id + "\" is already exist!");
            }
            this.files.put(id, file);
            return id;
        }
        return null;
    }

    public List<String> putAll(Iterable<MultipartFile> multipartFiles) {
        ArrayList<String> result = new ArrayList<String>();
        for (MultipartFile multipartFile : multipartFiles) {
            result.add(this.put(multipartFile));
        }
        return result;
    }

    public Path getFile(String id) {
        Path path = this.files.get(id);
        if (path == null) {
            path = this.tempFilePath.resolve(id);
            this.files.put(id, path);
        }
        if (Files.notExists(path, new LinkOption[0])) {
            this.files.remove(id);
            return null;
        }
        return path;
    }

    public void delete(String id) {
        Path file = this.files.remove(id);
        if (file == null) {
            throw new RuntimeException("file \"" + id + "\" not managed!");
        }
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public boolean contains(String id) {
        return this.files.containsKey(id);
    }

    protected void handleException(Exception e) {
        throw new RuntimeException(e);
    }

    @PostConstruct
    public void init() {
    }
}

