/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.PersonRole;
import com.imcode.entities.School;
import com.imcode.entities.SchoolClass;
import com.imcode.entities.WorkRole;
import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.services.PersonRoleService;
import com.imcode.services.UserService;
import com.imcode.utils.StaticUtls;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}/personroles"})
public class PersonRoleRestControllerImpl
extends AbstractRestController<PersonRole, Long, PersonRoleService> {
    @Autowired
    UserService userService;

    @RequestMapping(value={"/ofcurrentuser"}, method={RequestMethod.GET})
    public List<PersonRole> getPersonRolesOfCurrentUser(WebRequest webRequest) {
        return this._getPersonRolesOfCurrentUser(webRequest);
    }

    @RequestMapping(value={"/schools/ofcurrentuser"}, method={RequestMethod.GET})
    public List<School> getDistinctSchoolsOfCurrentUser(WebRequest webRequest) {
        return this.getDistinctItemsOfCurrentUser(webRequest, PersonRole::getSchool);
    }

    @RequestMapping(value={"/schoolclasses/ofcurrentuser"}, method={RequestMethod.GET})
    public List<SchoolClass> getDistinctSchoolClassesOfCurrentUser(WebRequest webRequest) {
        return this.getDistinctItemsOfCurrentUser(webRequest, PersonRole::getSchoolClass);
    }

    @RequestMapping(value={"/workroles/ofcurrentuser"}, method={RequestMethod.GET})
    public List<WorkRole> getDistinctRolesOfCurrentUser(WebRequest webRequest) {
        return this.getDistinctItemsOfCurrentUser(webRequest, PersonRole::getRole);
    }

    private List<PersonRole> _getPersonRolesOfCurrentUser(WebRequest webRequest) {
        return ((PersonRoleService)this.getService()).findByPerson(StaticUtls.getCurrentUser(webRequest, this.userService).getPerson());
    }

    private <T extends AbstractIdEntity<Long>> List<T> getDistinctItemsOfCurrentUser(WebRequest webRequest, Function<PersonRole, T> t) {
        HashMap distinct = new HashMap();
        this._getPersonRolesOfCurrentUser(webRequest).stream().map(t).forEach(item -> distinct.putIfAbsent(item.getId(), item));
        return new ArrayList(distinct.values());
    }
}

