/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.Person;
import com.imcode.entities.Pupil;
import com.imcode.services.PersonService;
import com.imcode.services.PupilService;
import com.imcode.utils.StaticUtls;
import com.imcode.validators.GeneralValidator;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/pupils"})
public class PupilController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String MAIN_PATH = "pupils";
    @Autowired
    private PupilService mainService;
    @Autowired
    private PersonService personService;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView list(ModelAndView model) {
        model.setViewName("pupils/list");
        model.addObject("entityList", (Object)this.mainService.findAll());
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.GET})
    public ModelAndView updateForm(@PathVariable(value="id") Pupil entity, ModelAndView model) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(entity, "try invoke update form for non exist pupil");
        model.setViewName("pupils/edit");
        model.addObject("entity", (Object)entity);
        return model;
    }

    @RequestMapping(params={"form"}, method={RequestMethod.GET})
    public ModelAndView createForm(ModelAndView model) {
        Pupil entity = new Pupil();
        model.setViewName("pupils/edit");
        model.addObject("entity", (Object)entity);
        return model;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView create(@ModelAttribute(value="entity") @Valid Pupil entity, ModelAndView model) throws MethodArgumentNotValidException {
        BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult((Object)entity, "pupil");
        new GeneralValidator(true, "id").invoke(entity, (BindingResult)bindingResult);
        this.mainService.save((Object)entity);
        model.setViewName("redirect:/pupils");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    public ModelAndView update(@PathVariable(value="id") @ModelAttribute(value="entity") Pupil persistEntity, @ModelAttribute(value="entity") @Valid Pupil entity, ModelAndView model) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(persistEntity, "Try update non exist pupil");
        Person persistPerson = persistEntity.getPerson();
        Person entityPerson = entity.getPerson();
        persistPerson.setPersonalId(entityPerson.getPersonalId());
        persistPerson.setFirstName(entityPerson.getFirstName());
        persistPerson.setLastName(entityPerson.getLastName());
        this.personService.save((Object)persistPerson);
        model.setViewName("redirect:/pupils");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable(value="id") Long id) throws MethodArgumentNotValidException {
        Pupil pupil = (Pupil)this.mainService.find((Object)id);
        StaticUtls.rejectNullValue(pupil, "Try update non exist pupil");
        this.mainService.delete((Object)id);
    }
}

