/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.specifications;

import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.search.SearchCriteria;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class JpaEntitySpecification<T extends JpaEntity>
implements Specification<T> {
    private SearchCriteria criteria;

    public JpaEntitySpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        switch (this.criteria.getOperation()) {
            case EQUALS: {
                return builder.equal((Expression)root.get(this.criteria.getFieldName()), this.criteria.getValue());
            }
            case NOT_EQUALS: {
                return builder.notEqual((Expression)root.get(this.criteria.getFieldName()), this.criteria.getValue());
            }
            case GREATER_THAN: {
                return builder.greaterThan((Expression)root.get(this.criteria.getFieldName()), (Comparable)((Object)this.criteria.getValue().toString()));
            }
            case LESS_THAN: {
                return builder.lessThan((Expression)root.get(this.criteria.getFieldName()), (Comparable)((Object)this.criteria.getValue().toString()));
            }
            case LIKE: {
                return builder.like((Expression)root.get(this.criteria.getFieldName()), this.criteria.getValue().toString());
            }
            case STARTS_WITH: {
                return builder.like((Expression)root.get(this.criteria.getFieldName()), this.criteria.getValue() + "%");
            }
            case ENDS_WITH: {
                return builder.like((Expression)root.get(this.criteria.getFieldName()), "%" + this.criteria.getValue());
            }
            case CONTAINS: {
                return builder.like((Expression)root.get(this.criteria.getFieldName()), "%" + this.criteria.getValue() + "%");
            }
        }
        return null;
    }
}

