/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.repositories;

import com.imcode.entities.Permission;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface PermissionRepository
extends JpaRepository<Permission, Long>,
JpaSpecificationExecutor<Permission> {
    @Query(value="select p from Permission p order by p.entityName")
    public List<Permission> findAll();

    @Modifying(clearAutomatically=true)
    @Query(value="update Permission p set p.updated = false ")
    public void makeAllUnUpdated();

    @Modifying(clearAutomatically=true)
    @Query(value="update Permission p set p.updated = true where p.hash = :hash")
    public void setUpdated(@Param(value="hash") Integer var1);

    public List<Permission> findByUpdatedFalse();

    @Modifying(clearAutomatically=true)
    @Query(value="DELETE FROM dbo_role_permission_cross WHERE permission_id = ?1 ", nativeQuery=true)
    public void deleteAssociation(Long var1);

    @Query(value="select case when p is not null then true else false end from Permission p, Role rC, Role rU, JpaClientDetails c, User u where rC member of c.authorities and rU member of u.roles and p member of rU.permissions and p member of rC.permissions and c.clientId = :clientId and u.id = :userId and p.hash = :hash")
    public Boolean getPermission(@Param(value="clientId") String var1, @Param(value="userId") Long var2, @Param(value="hash") Integer var3);
}

