/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.exceptions.factories.ErrorBuilder;
import com.imcode.exceptions.wrappers.GeneralError;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class ExceptionHandlerController {
    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ModelAndView handleException(Exception exception) {
        BindingResult bindingResult;
        GeneralError generalError = null;
        if (exception instanceof MethodArgumentNotValidException) {
            bindingResult = ((MethodArgumentNotValidException)exception).getBindingResult();
            generalError = ErrorBuilder.buildValidationError((Errors)bindingResult);
        } else if (exception instanceof BindException) {
            bindingResult = ((BindException)exception).getBindingResult();
            generalError = ErrorBuilder.buildValidationError((Errors)bindingResult);
        } else if (exception instanceof ConstraintViolationException) {
            Set constraintViolations = ((ConstraintViolationException)exception).getConstraintViolations();
            LinkedList<String> description = new LinkedList<String>();
            constraintViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toCollection(() -> description));
            generalError = ErrorBuilder.buildValidationError(description);
        } else {
            generalError = exception instanceof DataAccessException ? ErrorBuilder.buildDatabasePersistenceError(exception) : (exception instanceof HttpMessageConversionException ? ErrorBuilder.buildJsonMappingException(exception) : ErrorBuilder.buildUncaughtException(exception));
        }
        ModelAndView model = new ModelAndView();
        model.addObject((Object)generalError);
        model.setViewName("errors/error");
        return model;
    }
}

