/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Activity;
import com.imcode.services.ActivityService;
import com.imcode.services.UserService;
import com.imcode.utils.IssueAttachmentFileUtil;
import com.imcode.utils.StaticUtls;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@RestController
@RequestMapping(value={"/v1/{format}/activities"})
public class ActivityRestControllerImpl
extends AbstractRestController<Activity, Long, ActivityService> {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private UserService userService;

    @Override
    public Activity create(@RequestBody @Valid Activity entity, HttpServletResponse response, BindingResult bindingResult, WebRequest webRequest) throws Exception {
        entity.setReportedDate(new Date());
        entity.setReportedBy(StaticUtls.getCurrentUser(webRequest, this.userService).getPerson());
        return super.create(entity, response, bindingResult, webRequest);
    }

    @RequestMapping(value={"/attach/{id}"}, method={RequestMethod.POST})
    public String setAttachment(@PathVariable(value="id") Long activityId, @RequestParam(value="file") CommonsMultipartFile attachment, WebRequest webRequest) {
        IssueAttachmentFileUtil issueAttachmentFileUtil = new IssueAttachmentFileUtil();
        Activity activity = (Activity)this.activityService.find((Object)activityId);
        issueAttachmentFileUtil.deleteIfExcist(activity, this.servletContext);
        activity.setFileName(attachment.getOriginalFilename());
        activity = (Activity)this.activityService.save((Object)activity);
        if (!attachment.isEmpty() && activity != null) {
            issueAttachmentFileUtil.saveActivityAttachment(activity, (MultipartFile)attachment, this.servletContext);
        }
        return activity.getFileName();
    }

    @RequestMapping(value={"/attach/{id}"}, method={RequestMethod.GET})
    public void getAttachment(@PathVariable(value="id") Long activityId, HttpServletResponse response, WebRequest webRequest) {
        Activity activity = (Activity)this.activityService.find((Object)activityId);
        if (activity != null && activity.getFileName() != null) {
            IssueAttachmentFileUtil issueAttachmentFileUtil = new IssueAttachmentFileUtil();
            issueAttachmentFileUtil.saveActivityAttachmentInResponse(activity, response, this.servletContext);
        }
    }
}

