/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.services.jpa;

import com.imcode.entities.User;
import com.imcode.entities.oauth2.JpaClientDetails;
import com.imcode.oauth2.IvisClientDetailsService;
import com.imcode.repositories.oauth2.ClietnDetailsRepository;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Repository
public class ClientDetailsServiceRepoImpl
implements IvisClientDetailsService {
    private static final Log logger = LogFactory.getLog(ClientDetailsServiceRepoImpl.class);
    @Autowired
    private ClietnDetailsRepository clietnDetailsRepository;

    @Transactional(readOnly=true)
    public JpaClientDetails loadClientByClientId(String clientId) throws ClientRegistrationException {
        JpaClientDetails clientDetails = (JpaClientDetails)this.clietnDetailsRepository.findOne((Serializable)((Object)clientId));
        if (clientDetails == null) {
            throw new NoSuchClientException("No client with requested id: " + clientId);
        }
        return clientDetails;
    }

    public void addClientDetails(ClientDetails clientDetails) throws ClientAlreadyExistsException {
        if (clientDetails.getClientId() != null && this.clietnDetailsRepository.exists((Serializable)((Object)clientDetails.getClientId()))) {
            throw new ClientAlreadyExistsException("Client already exists: " + clientDetails.getClientId());
        }
        this.clietnDetailsRepository.save((JpaClientDetails)clientDetails);
    }

    public void updateClientDetails(ClientDetails clientDetails) throws NoSuchClientException {
        if (clientDetails.getClientId() != null && !this.clietnDetailsRepository.exists((Serializable)((Object)clientDetails.getClientId()))) {
            throw new NoSuchClientException("No client found with id = " + clientDetails.getClientId());
        }
        this.clietnDetailsRepository.save((JpaClientDetails)clientDetails);
    }

    public void updateClientSecret(String clientId, String secret) throws NoSuchClientException {
        JpaClientDetails client = (JpaClientDetails)this.clietnDetailsRepository.findOne((Serializable)((Object)clientId));
        if (client == null) {
            throw new NoSuchClientException("No client found with id = " + clientId);
        }
        client.setClientSecret(secret);
    }

    public void removeClientDetails(String clientId) throws NoSuchClientException {
        if (clientId != null && !this.clietnDetailsRepository.exists((Serializable)((Object)clientId))) {
            throw new NoSuchClientException("No client found with id = " + clientId);
        }
        this.clietnDetailsRepository.delete((Serializable)((Object)clientId));
    }

    @Transactional(readOnly=true)
    public List listClientDetails() {
        return this.clietnDetailsRepository.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public JpaClientDetails findUserClientById(String id, User owner) {
        return this.clietnDetailsRepository.findByOwnerAndClientId(owner, id);
    }

    @Override
    @Transactional(readOnly=true)
    public List<JpaClientDetails> findAllUserClients(User owner) {
        return this.clietnDetailsRepository.findByOwner(owner);
    }

    @Override
    @Transactional(readOnly=true)
    public List<JpaClientDetails> findAll() {
        return this.clietnDetailsRepository.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public JpaClientDetails findOne(String clientId) {
        return (JpaClientDetails)this.clietnDetailsRepository.findOne((Serializable)((Object)clientId));
    }
}

