/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.security.interceptors;

import com.imcode.entities.User;
import com.imcode.services.PermissionService;
import com.imcode.utils.StaticUtls;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AccessApiInterceptor
extends HandlerInterceptorAdapter {
    private final PermissionService permissionService;

    @Autowired
    public AccessApiInterceptor(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        Integer hash;
        Long userId;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof OAuth2Authentication)) {
            response.setStatus(401);
            return false;
        }
        OAuth2Authentication oauth2Authentication = (OAuth2Authentication)authentication;
        OAuth2Request clientAuthentication = oauth2Authentication.getOAuth2Request();
        String clientId = clientAuthentication.getClientId();
        Boolean permitted = this.permissionService.isPermitted(clientId, userId = (Long)((User)oauth2Authentication.getUserAuthentication().getPrincipal()).getId(), hash = StaticUtls.getHashFrom(handlerMethod = (HandlerMethod)handler));
        if (Objects.isNull(permitted)) {
            response.setStatus(403);
            return false;
        }
        return permitted;
    }
}

