/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities.oauth2;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.entities.enums.AuthorizedGrantType;
import com.imcode.oauth2.IvisClientDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.client.Jackson2ArrayOrStringDeserializer;
import org.springframework.security.oauth2.provider.client.JacksonArrayOrStringDeserializer;
import org.springframework.util.StringUtils;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
@org.codehaus.jackson.annotate.JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(ignoreUnknown=true)
@Entity
@Table(name="dbo_oauth_client_details")
public class JpaClientDetails
implements IvisClientDetails,
Serializable {
    @Id
    @Column(name="id", length=36, nullable=false)
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    @org.codehaus.jackson.annotate.JsonProperty(value="client_id")
    @JsonProperty(value="client_id")
    private String clientId;
    @NotNull(message="name is required")
    @Size(min=4, max=100, message="name must have min 4, max 100 characters")
    @Column(length=100, unique=true)
    @org.codehaus.jackson.annotate.JsonProperty(value="client_name")
    @JsonProperty(value="client_name")
    private String name;
    @NotNull(message="name is required")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="owner_id")
    @org.codehaus.jackson.annotate.JsonProperty(value="client_owner")
    @JsonProperty(value="client_owner")
    private User owner;
    @NotNull(message="client secret is required")
    @Size(min=4, max=100, message="clientSecret must have min 4, max 100 characters")
    @Column(name="client_secret")
    @org.codehaus.jackson.annotate.JsonProperty(value="client_secret")
    @JsonProperty(value="client_secret")
    private String clientSecret;
    @Transient
    @org.codehaus.jackson.annotate.JsonProperty(value="scope")
    @JsonDeserialize(using=JacksonArrayOrStringDeserializer.class)
    @JsonProperty(value="scope")
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private Set<String> scope = new HashSet<String>();
    @Size(min=1, message="resourceId is required")
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="dbo_oauth_client_resources", joinColumns={@JoinColumn(name="client_id")})
    @Column(name="resource_id")
    @org.codehaus.jackson.annotate.JsonProperty(value="resource_ids")
    @JsonDeserialize(using=JacksonArrayOrStringDeserializer.class)
    @JsonProperty(value="resource_ids")
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private Set<String> resourceIds = Collections.emptySet();
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="dbo_oauth_client_grant_types", joinColumns={@JoinColumn(name="client_id")})
    @Column(name="authorized_grant_type")
    @org.codehaus.jackson.annotate.JsonProperty(value="authorized_grant_types")
    @JsonDeserialize(using=JacksonArrayOrStringDeserializer.class)
    @JsonProperty(value="authorized_grant_types")
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private Set<String> authorizedGrantTypes = Collections.emptySet();
    @Size(min=1, message="registered redirect uri is required")
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="dbo_oauth_client_redirect_uris", joinColumns={@JoinColumn(name="client_id")})
    @Column(name="registered_redirect_uris")
    @org.codehaus.jackson.annotate.JsonProperty(value="redirect_uri")
    @JsonDeserialize(using=JacksonArrayOrStringDeserializer.class)
    @JsonProperty(value="redirect_uri")
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private Set<String> registeredRedirectUris;
    @Transient
    @org.codehaus.jackson.annotate.JsonProperty(value="autoapprove")
    @JsonDeserialize(using=JacksonArrayOrStringDeserializer.class)
    @JsonProperty(value="autoapprove")
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private Set<String> autoApproveScopes;
    @Size(min=1, message="at least 1 roles must be checked")
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=Role.class)
    @JoinTable(name="dbo_oauth_client_roles_cross", joinColumns={@JoinColumn(name="client_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private Set<Role> authorities;
    @NotNull(message="accessTokenValiditySeconds is required")
    @Min(value=90L, message="minimum 90 seconds of accessTokenValiditySeconds")
    @Column(name="access_token_validity_seconds")
    @org.codehaus.jackson.annotate.JsonProperty(value="access_token_validity")
    @JsonProperty(value="access_token_validity")
    private Integer accessTokenValiditySeconds;
    @NotNull(message="refreshTokenValiditySeconds is required")
    @Min(value=180L, message="minimum 180 seconds of refreshTokenValiditySeconds")
    @Column(name="refresh_token_validity_seconds")
    @org.codehaus.jackson.annotate.JsonProperty(value="refresh_token_validity")
    @JsonProperty(value="refresh_token_validity")
    private Integer refreshTokenValiditySeconds;
    @ElementCollection(fetch=FetchType.EAGER, targetClass=String.class)
    @MapKeyColumn(name="name", length=100)
    @Column(name="value")
    @CollectionTable(name="dbo_oauth_client_additional_info", joinColumns={@JoinColumn(name="client_id")})
    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    private Map<String, Object> additionalInformation = new LinkedHashMap<String, Object>();

    public JpaClientDetails() {
    }

    public JpaClientDetails(JpaClientDetails prototype) {
        this.setAccessTokenValiditySeconds(prototype.getAccessTokenValiditySeconds());
        this.setRefreshTokenValiditySeconds(prototype.getRefreshTokenValiditySeconds());
        this.setAuthorizedGrantTypes(prototype.getAuthorizedGrantTypes());
        this.setClientSecret(prototype.getClientSecret());
        this.setRegisteredRedirectUri(prototype.getRegisteredRedirectUri());
        this.setScope(prototype.getScope());
        this.setResourceIds(prototype.getResourceIds());
        this.setOwner(prototype.getOwner());
        this.setName(prototype.getName());
    }

    public JpaClientDetails(String name, User owner, String resourceIds, String scopes, String grantTypes, String authorities) {
        this(name, owner, resourceIds, scopes, grantTypes, authorities, null);
    }

    public JpaClientDetails(String name, User owner, String resourceIds, String scopes, String grantTypes, String authorities, String redirectUris) {
        Set scopeList;
        Set resources;
        this.name = name;
        this.owner = owner;
        if (StringUtils.hasText((String)resourceIds) && !(resources = StringUtils.commaDelimitedListToSet((String)resourceIds)).isEmpty()) {
            this.resourceIds = resources;
        }
        if (StringUtils.hasText((String)scopes) && !(scopeList = StringUtils.commaDelimitedListToSet((String)scopes)).isEmpty()) {
            this.scope = scopeList;
        }
        this.authorizedGrantTypes = StringUtils.hasText((String)grantTypes) ? StringUtils.commaDelimitedListToSet((String)grantTypes) : new HashSet<String>(Arrays.asList("authorization_code", "refresh_token"));
        if (StringUtils.hasText((String)redirectUris)) {
            this.registeredRedirectUris = StringUtils.commaDelimitedListToSet((String)redirectUris);
        }
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAutoApproveScopes(Collection<String> autoApproveScopes) {
        this.autoApproveScopes = new HashSet<String>(autoApproveScopes);
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public Set<String> getAutoApproveScopes() {
        return this.autoApproveScopes;
    }

    public boolean isAutoApprove(String scope) {
        return true;
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public boolean isSecretRequired() {
        return this.clientSecret != null;
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public boolean isScoped() {
        return false;
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public Set<String> getScope() {
        return new HashSet<String>();
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public void setScope(Set<String> scope) {
        this.scope = scope == null ? Collections.emptySet() : new LinkedHashSet<String>(scope);
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Set<String> resourceIds) {
        this.resourceIds = resourceIds == null ? Collections.emptySet() : new LinkedHashSet<String>(resourceIds);
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public Set<String> getAuthorizedGrantTypes() {
        return this.authorizedGrantTypes;
    }

    public void setAuthorizedGrantTypes(Set<String> authorizedGrantTypes) {
        this.authorizedGrantTypes = new LinkedHashSet<String>(authorizedGrantTypes);
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public Set<String> getRegisteredRedirectUri() {
        return this.registeredRedirectUris;
    }

    public void setRegisteredRedirectUri(Set<String> registeredRedirectUris) {
        this.registeredRedirectUris = registeredRedirectUris == null ? null : new LinkedHashSet<String>(registeredRedirectUris);
    }

    @org.codehaus.jackson.annotate.JsonProperty(value="authorities")
    @JsonProperty(value="authorities")
    private List<String> getAuthoritiesAsStrings() {
        return new ArrayList<String>(AuthorityUtils.authorityListToSet(this.authorities));
    }

    @org.codehaus.jackson.annotate.JsonProperty(value="authorities")
    @JsonDeserialize(using=JacksonArrayOrStringDeserializer.class)
    @JsonProperty(value="authorities")
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private void setAuthoritiesAsStrings(Set<String> values) {
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public Set<GrantedAuthority> getAuthorities() {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        for (Role authority : this.authorities) {
            authorities.add((GrantedAuthority)authority);
        }
        return authorities;
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public void setAuthorities(Set<Role> authorities) {
        this.authorities = new HashSet<Role>(authorities);
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public Set<Role> getRoles() {
        return this.authorities;
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public void setRoles(Set<Role> authorities) {
        this.authorities = new HashSet<Role>(authorities);
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public Integer getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(Integer accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public Integer getRefreshTokenValiditySeconds() {
        return this.refreshTokenValiditySeconds;
    }

    public void setRefreshTokenValiditySeconds(Integer refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    public void setAdditionalInformation(Map<String, ?> additionalInformation) {
        this.additionalInformation = new LinkedHashMap(additionalInformation);
    }

    @JsonAnyGetter
    @com.fasterxml.jackson.annotation.JsonAnyGetter
    public Map<String, Object> getAdditionalInformation() {
        return Collections.unmodifiableMap(this.additionalInformation);
    }

    @org.codehaus.jackson.annotate.JsonAnySetter
    @JsonAnySetter
    public void addAdditionalInformation(String key, Object value) {
        this.additionalInformation.put(key, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessTokenValiditySeconds == null ? 0 : this.accessTokenValiditySeconds);
        result = 31 * result + (this.refreshTokenValiditySeconds == null ? 0 : this.refreshTokenValiditySeconds);
        result = 31 * result + (this.authorities == null ? 0 : this.authorities.hashCode());
        result = 31 * result + (this.authorizedGrantTypes == null ? 0 : this.authorizedGrantTypes.hashCode());
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = 31 * result + (this.registeredRedirectUris == null ? 0 : this.registeredRedirectUris.hashCode());
        result = 31 * result + (this.resourceIds == null ? 0 : this.resourceIds.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.additionalInformation == null ? 0 : this.additionalInformation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JpaClientDetails other = (JpaClientDetails)obj;
        if (this.accessTokenValiditySeconds != other.accessTokenValiditySeconds) {
            return false;
        }
        if (this.refreshTokenValiditySeconds != other.refreshTokenValiditySeconds) {
            return false;
        }
        if (this.authorities == null ? other.authorities != null : !this.authorities.equals(other.authorities)) {
            return false;
        }
        if (this.authorizedGrantTypes == null ? other.authorizedGrantTypes != null : !this.authorizedGrantTypes.equals(other.authorizedGrantTypes)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.clientSecret == null ? other.clientSecret != null : !this.clientSecret.equals(other.clientSecret)) {
            return false;
        }
        if (this.registeredRedirectUris == null ? other.registeredRedirectUris != null : !this.registeredRedirectUris.equals(other.registeredRedirectUris)) {
            return false;
        }
        if (this.resourceIds == null ? other.resourceIds != null : !this.resourceIds.equals(other.resourceIds)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        return !(this.additionalInformation == null ? other.additionalInformation != null : !this.additionalInformation.equals(other.additionalInformation));
    }

    public String toString() {
        return "JpaClientDetails [clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", scope=" + this.scope + ", resourceIds=" + this.resourceIds + ", authorizedGrantTypes=" + this.authorizedGrantTypes + ", registeredRedirectUris=" + this.registeredRedirectUris + ", authorities=" + this.authorities + ", accessTokenValiditySeconds=" + this.accessTokenValiditySeconds + ", refreshTokenValiditySeconds=" + this.refreshTokenValiditySeconds + ", additionalInformation=" + this.additionalInformation + "]";
    }

    public void setScope(String ... scope) {
        this.setScope(new HashSet<String>(Arrays.asList(scope)));
    }

    public void setScope(String scope) {
        this.setScope(new HashSet<String>(Arrays.asList(scope)));
    }

    public void setResourceIds(String ... resourceIds) {
        this.setResourceIds(new HashSet<String>(Arrays.asList(resourceIds)));
    }

    public void setResourceIds(String resourceId) {
        this.setResourceIds(new HashSet<String>(Arrays.asList(resourceId)));
    }

    public void setRegisteredRedirectUri(String ... redirectUris) {
        this.setRegisteredRedirectUri(new HashSet<String>(Arrays.asList(redirectUris)));
    }

    public void setRegisteredRedirectUri(String redirectUri) {
        this.setRegisteredRedirectUri(new HashSet<String>(Arrays.asList(redirectUri)));
    }

    public void setAuthoritiesOverload(GrantedAuthority ... authorities) {
    }

    public void setAuthoritiesOverload(List<? extends GrantedAuthority> authorities) {
    }

    public void setAuthoritiesOverload(GrantedAuthority authority) {
    }

    public void setAuthorizedGrantTypes(AuthorizedGrantType ... authorizedGrantTypes) {
        HashSet<String> grantTypesStrings = new HashSet<String>();
        for (AuthorizedGrantType authorizedGrantType : authorizedGrantTypes) {
            grantTypesStrings.add(authorizedGrantType.toString());
        }
        this.setAuthorizedGrantTypes(grantTypesStrings);
    }

    public void setAuthorizedGrantTypes(AuthorizedGrantType authorizedGrantType) {
        this.setAuthorizedGrantTypes(new HashSet<String>(Arrays.asList(authorizedGrantType.toString())));
    }

    public void addAuthorizedGrantType(AuthorizedGrantType authorizedGrantType) {
        this.authorizedGrantTypes.add(authorizedGrantType.toString());
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }
}

