/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.SchemaVersion;
import com.imcode.services.SchemaVersionService;
import com.imcode.utils.DatabaseWorker;
import com.imcode.utils.StaticUtls;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/schema_versions"})
public class SchemaVersionController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    private SchemaVersionService schemeVersionService;
    @Autowired
    private ServletContext servletContext;

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView migrate(@RequestParam(value="file") CommonsMultipartFile multipartFile, @RequestParam(value="description", required=false) String description, WebRequest webRequest) {
        SchemaVersion currentVersion = this.createCurrentVersion(multipartFile.getOriginalFilename(), description);
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, currentVersion, this.servletContext);
        if (!databaseWorker.runScript((MultipartFile)multipartFile)) {
            this.schemeVersionService.delete(currentVersion.getId());
        } else {
            databaseWorker.createVersionDump();
        }
        return new ModelAndView("redirect:/test.html");
    }

    @RequestMapping(value={"/current"}, method={RequestMethod.GET})
    @ResponseBody
    public SchemaVersion getCurrentSchemaVersion(WebRequest webRequest) {
        return this.schemeVersionService.findCurrentVersion();
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<SchemaVersion> getAllSchemaVersion(WebRequest webRequest) {
        return this.schemeVersionService.findAll();
    }

    @RequestMapping(value={"/access"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getDataAccess(WebRequest webRequest) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("URL", this.dataSource.getUrl());
        objectMap.put("LOGIN", this.dataSource.getUsername());
        objectMap.put("PASSWORD", this.dataSource.getPassword());
        return objectMap;
    }

    @RequestMapping(value={"/current/{version}"}, method={RequestMethod.POST})
    @ResponseBody
    public SchemaVersion migrateToVersion(@PathVariable(value="version") String version, WebRequest webRequest) {
        SchemaVersion schemaVersion = this.schemeVersionService.findVersion(version);
        if (schemaVersion.getCurrent().booleanValue()) {
            return schemaVersion;
        }
        SchemaVersion currentVersion = this.schemeVersionService.findCurrentVersion();
        currentVersion.setCurrent(false);
        this.schemeVersionService.save(currentVersion);
        schemaVersion.setCurrent(true);
        this.schemeVersionService.save(schemaVersion);
        List schemaVersionList = this.schemeVersionService.findAll();
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, schemaVersion, this.servletContext);
        databaseWorker.migrateToVersion();
        this.schemeVersionService.findAll().stream().forEach(schema -> this.schemeVersionService.delete(schema.getId()));
        this.schemeVersionService.save(schemaVersionList);
        return schemaVersion;
    }

    @RequestMapping(value={"/dump/{version}"}, method={RequestMethod.GET})
    public void getVersionDump(@PathVariable(value="version") String version, HttpServletResponse httpServletResponse, WebRequest webRequest) {
        SchemaVersion schemaVersion = this.schemeVersionService.findVersion(version);
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, schemaVersion, this.servletContext);
        databaseWorker.saveVersionDumpInResponse(httpServletResponse);
    }

    @RequestMapping(value={"/script/{version}"}, method={RequestMethod.GET})
    public void getVersionScript(@PathVariable(value="version") String version, HttpServletResponse httpServletResponse, WebRequest webRequest) {
        SchemaVersion schemaVersion = this.schemeVersionService.findVersion(version);
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, schemaVersion, this.servletContext);
        databaseWorker.saveVersionScriptInResponse(httpServletResponse);
    }

    @RequestMapping(value={"/dump"}, method={RequestMethod.GET})
    public void getVersionDump(HttpServletResponse httpServletResponse, WebRequest webRequest) {
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, null, this.servletContext);
        databaseWorker.saveVersionDumpInResponse(httpServletResponse);
    }

    @RequestMapping(value={"/delete/{version}"}, method={RequestMethod.POST})
    public ModelAndView deleteSchemaVersion(@PathVariable(value="version") String version, WebRequest webRequest) {
        SchemaVersion schemaVersion = this.schemeVersionService.findVersion(version);
        if (schemaVersion.getCurrent().booleanValue()) {
            return new ModelAndView("redirect:/test.html");
        }
        this.schemeVersionService.delete(schemaVersion.getId());
        DatabaseWorker databaseWorker = new DatabaseWorker(this.dataSource, schemaVersion, this.servletContext);
        databaseWorker.deleteVersion();
        return new ModelAndView("redirect:/test.html");
    }

    @RequestMapping(value={"/command"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> executeCommand(HttpServletRequest request, WebRequest webRequest) {
        String line;
        String cmd = request.getParameter("cmd");
        String config = request.getParameter("config");
        Process process = StaticUtls.executeCmdConfig(cmd, config);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("exit code", process.exitValue());
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuffer output = new StringBuffer();
        try {
            line = "";
            while ((line = reader.readLine()) != null) {
                output.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        response.put("output", output.toString());
        reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        output = new StringBuffer();
        try {
            line = "";
            while ((line = reader.readLine()) != null) {
                output.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        response.put("error", output.toString());
        return response;
    }

    private SchemaVersion createCurrentVersion(String versionName, String description) {
        SchemaVersion currentVersion = this.schemeVersionService.findCurrentVersion();
        if (currentVersion != null) {
            currentVersion.setCurrent(false);
            this.schemeVersionService.save(currentVersion);
        }
        SchemaVersion schemaVersion = new SchemaVersion();
        schemaVersion.setCurrent(true);
        schemaVersion.setVersion(versionName.substring(0, versionName.indexOf(".sql")));
        schemaVersion.setTimestamp(new Date());
        if (description != null) {
            schemaVersion.setDescription(description);
        }
        return (SchemaVersion)this.schemeVersionService.save(schemaVersion);
    }
}

