/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.Role;
import com.imcode.services.PermissionService;
import com.imcode.services.RoleService;
import com.imcode.utils.StaticUtls;
import com.imcode.validators.GeneralValidator;
import java.lang.reflect.InvocationTargetException;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/roles"})
public class RolesController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String MAIN_PATH = "roles";
    private final RoleService mainService;
    private final PermissionService permissionService;

    @Autowired
    public RolesController(RoleService roleService, PermissionService permissionService) {
        this.mainService = roleService;
        this.permissionService = permissionService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView list(ModelAndView model) {
        model.setViewName("roles/list");
        model.addObject("entityList", (Object)this.mainService.findAllNonInternal());
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.GET})
    public ModelAndView updateForm(@PathVariable(value="id") Role entity, ModelAndView model) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(entity, "try invoke update form for non exist role");
        model.setViewName("roles/edit");
        model.addObject("entity", (Object)entity);
        model.addObject("permissionsAll", (Object)this.permissionService.findAll());
        return model;
    }

    @RequestMapping(params={"form"}, method={RequestMethod.GET})
    public ModelAndView createForm(ModelAndView model) {
        Role entity = new Role();
        model.setViewName("roles/edit");
        model.addObject("entity", (Object)entity);
        model.addObject("permissionsAll", (Object)this.permissionService.findAll());
        return model;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView create(@ModelAttribute(value="entity") @Valid Role entity, ModelAndView model) throws MethodArgumentNotValidException {
        BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult((Object)entity, "role");
        new GeneralValidator(true, "id").invoke(entity, (BindingResult)bindingResult);
        entity.setInternal(Boolean.valueOf(false));
        this.mainService.save((Object)entity);
        model.setViewName("redirect:/roles");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    public ModelAndView update(@PathVariable(value="id") Role persistEntity, @ModelAttribute(value="entity") @Valid Role entity, ModelAndView model) throws MethodArgumentNotValidException, InvocationTargetException, IllegalAccessException {
        StaticUtls.rejectNullValue(persistEntity, "Try update non exist role");
        entity.setInternal(Boolean.valueOf(false));
        StaticUtls.nullAwareBeanCopy(persistEntity, entity);
        persistEntity.setPermissions(entity.getPermissions());
        this.mainService.save((Object)persistEntity);
        model.setViewName("redirect:/roles");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable(value="id") Long id) throws MethodArgumentNotValidException {
        Role role = (Role)this.mainService.find((Object)id);
        StaticUtls.rejectNullValue(role, "Try delete non exist role");
        this.mainService.delete((Object)id);
    }
}

