/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers;

import com.imcode.controllers.CrudController;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.exceptions.factories.ErrorBuilder;
import com.imcode.exceptions.wrappers.GeneralError;
import com.imcode.services.GenericService;
import com.imcode.services.NamedService;
import com.imcode.services.PersonalizedService;
import com.imcode.utils.StaticUtls;
import com.imcode.validators.GeneralValidator;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.ui.Model;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;

public abstract class AbstractRestController<T extends JpaEntity<ID>, ID extends Serializable, SERVICE_TYPE extends GenericService<T, ID>>
implements CrudController<T, ID> {
    @Autowired
    private SERVICE_TYPE service;

    @Override
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public Object get(@PathVariable(value="id") ID id, HttpServletResponse response, WebRequest webRequest) throws Exception {
        JpaEntity entity = (JpaEntity)this.service.find(id);
        StaticUtls.checkNullAndSetNoContent(entity, response);
        return entity;
    }

    @Override
    @RequestMapping(method={RequestMethod.GET})
    public Object getAll(WebRequest webRequest, HttpServletResponse response, Model model) throws Exception {
        List result = this.service.findAll();
        StaticUtls.checkNullAndSetNoContent(result, response);
        return result;
    }

    @Override
    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Object create(@RequestBody @Valid T entity, HttpServletResponse response, BindingResult bindingResult, WebRequest webRequest) throws Exception {
        entity.setId(null);
        return this.service.save(entity);
    }

    @RequestMapping(value={"/saveall"}, method={RequestMethod.POST})
    @ResponseBody
    public Object saveAll(@RequestBody Iterable<T> entities, HttpServletResponse response, WebRequest webRequest, @RequestParam(required=false) Boolean full) throws Exception {
        Iterable result = this.service.save(entities);
        if (Boolean.FALSE.equals(full)) {
            List ids = StreamSupport.stream(result.spliterator(), false).map(JpaEntity::getId).collect(Collectors.toList());
            return ids;
        }
        return result;
    }

    @Override
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public Object update(@PathVariable(value="id") ID id, HttpServletResponse response, @RequestBody(required=false) @Valid T entity, BindingResult bindingResult, WebRequest webRequest) throws Exception {
        JpaEntity existsEntity = (JpaEntity)this.getService().find(id);
        if (existsEntity == null) {
            bindingResult.reject(null, "Try update non exist entity");
            throw new MethodArgumentNotValidException(null, bindingResult);
        }
        entity.setId(null);
        boolean isCopied = false;
        try {
            isCopied = StaticUtls.nullAwareBeanCopy(existsEntity, entity);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (isCopied) {
            existsEntity = (JpaEntity)this.service.save((Object)existsEntity);
        } else {
            StaticUtls.checkNullAndSetNoContent(null, response);
        }
        return existsEntity;
    }

    @Override
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public Object delete(@PathVariable(value="id") ID id, HttpServletResponse response, WebRequest webRequest) throws Exception {
        JpaEntity entity = (JpaEntity)this.service.find(id);
        if (entity == null) {
            BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult((Object)entity, "entity");
            bindingResult.reject(null, "Try delete non exist entity");
            throw new MethodArgumentNotValidException(null, (BindingResult)bindingResult);
        }
        this.service.delete(id);
        return entity;
    }

    public Object getByName(WebRequest webRequest, Model model, HttpServletResponse response, @RequestParam(value="name") String name, @RequestParam(value="first", required=false) Boolean firstOnly) {
        if (this.service instanceof NamedService) {
            NamedService namedService = (NamedService)this.service;
            if (firstOnly == null || !firstOnly.booleanValue()) {
                List byName = namedService.findByName(name);
                StaticUtls.checkNullAndSetNoContent(byName, response);
                return byName;
            }
            JpaEntity firstByName = (JpaEntity)namedService.findFirstByName(name);
            StaticUtls.checkNullAndSetNoContent(firstByName, response);
            return firstByName;
        }
        throw new UnsupportedOperationException("findByName method not supported!");
    }

    public Object getByPersonalId(@RequestParam(value="personalId") String personId, @RequestParam(value="first", required=false) Boolean firstOnly, HttpServletResponse response) {
        if (this.service instanceof PersonalizedService) {
            PersonalizedService personalizedService = (PersonalizedService)this.service;
            if (firstOnly == null || !firstOnly.booleanValue()) {
                List byPersonalId = personalizedService.findByPersonalId(personId);
                StaticUtls.checkNullAndSetNoContent(byPersonalId, response);
                return byPersonalId;
            }
            JpaEntity firstByPersonalId = (JpaEntity)personalizedService.findFirstByPersonalId(personId);
            StaticUtls.checkNullAndSetNoContent(firstByPersonalId, response);
            return firstByPersonalId;
        }
        throw new UnsupportedOperationException("findByName method not supported!");
    }

    public SERVICE_TYPE getService() {
        return this.service;
    }

    public void setService(SERVICE_TYPE service) {
        this.service = service;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new GeneralValidator(this.getFieldsConstraints()));
    }

    protected Map<String, Map<GeneralValidator.Constraint, String>> getFieldsConstraints() {
        HashMap<String, Map<GeneralValidator.Constraint, String>> constraints = new HashMap<String, Map<GeneralValidator.Constraint, String>>();
        return constraints;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public GeneralError handleException(Exception exception) {
        if (exception instanceof MethodArgumentNotValidException) {
            BindingResult bindingResult = ((MethodArgumentNotValidException)exception).getBindingResult();
            return ErrorBuilder.buildValidationError((Errors)bindingResult);
        }
        if (exception instanceof DataAccessException) {
            return ErrorBuilder.buildDatabasePersistenceError(exception);
        }
        if (exception instanceof HttpMessageConversionException) {
            return ErrorBuilder.buildJsonMappingException(exception);
        }
        return ErrorBuilder.buildUncaughtException(exception);
    }
}

