/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.OnceTimeAccessToken;
import com.imcode.entities.Person;
import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.entities.embed.Email;
import com.imcode.entities.embed.Phone;
import com.imcode.entities.enums.CommunicationTypeEnum;
import com.imcode.exceptions.factories.ErrorBuilder;
import com.imcode.exceptions.wrappers.GeneralError;
import com.imcode.oauth2.IvisClientDetailsService;
import com.imcode.services.OnceTimeAccessTokenService;
import com.imcode.services.PersonService;
import com.imcode.services.RoleService;
import com.imcode.services.UserService;
import com.imcode.utils.MailSenderUtil;
import com.imcode.utils.StaticUtls;
import com.imcode.validators.GeneralValidator;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AdminController {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ConsumerTokenServices tokenServices;
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private IvisClientDetailsService clientDetailsService;
    @Value(value="${Hibernate.dialect}")
    private String test;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PersonService personService;
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="${mail.smtp.from.address}")
    private String fromAddress;
    @Value(value="${mail.smtp.from.username}")
    private String fromUsername;
    @Autowired
    public OnceTimeAccessTokenService onceTimeAccessTokenService;
    @Value(value="${server.name}")
    private String serverName;

    @RequestMapping(value={"/oauth/users/{user}/tokens/{token}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> revokeToken(@PathVariable String user, @PathVariable String token, Principal principal) throws Exception {
        this.checkResourceOwner(user, principal);
        if (this.tokenServices.revokeToken(token)) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/oauth/clients/{client}/tokens"})
    @ResponseBody
    public Collection<OAuth2AccessToken> listTokensForClient(@PathVariable String client) throws Exception {
        return this.tokenStore.findTokensByClientId(client);
    }

    @RequestMapping(value={"/oauth/tokens"}, method={RequestMethod.GET})
    public String tokenList(Model model) {
        IvisClientDetailsService ClientDetailsService2 = this.clientDetailsService;
        List clients = this.clientDetailsService.listClientDetails();
        LinkedList tokens = new LinkedList();
        for (ClientDetails clientDetails : clients) {
            Collection tokensByClientId = this.tokenStore.findTokensByClientId(clientDetails.getClientId());
            if (tokensByClientId == null) continue;
            tokens.addAll(tokensByClientId);
        }
        model.addAttribute("tokens", tokens);
        return "tokens";
    }

    @RequestMapping(value={"/oauth/tokens/{tokenVlue}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean delete(@PathVariable(value="tokenVlue") String tokenValue) {
        return this.tokenServices.revokeToken(tokenValue);
    }

    @RequestMapping(value={"/login"})
    public ModelAndView login(@RequestParam(value="display", required=false) String display, WebRequest webRequest, ModelAndView model) {
        boolean isPopup;
        boolean bl = isPopup = display != null && "popup".equals(display);
        if (isPopup) {
            model.setViewName("security/login_popup");
        } else {
            model.setViewName("security/login");
        }
        return model;
    }

    @RequestMapping(value={"/registration"})
    public ModelAndView registration(WebRequest webRequest, ModelAndView model) {
        User user = new User();
        model.addObject((Object)user);
        model.setViewName("security/registration");
        return model;
    }

    @RequestMapping(value={"/registration/do"}, params={"firstName", "lastName", "email", "contactPhone"}, method={RequestMethod.POST})
    public ModelAndView registrationDo(@ModelAttribute(value="user") User user, @RequestParam(value="firstName") String firstName, @RequestParam(value="lastName") String lastName, @RequestParam(value="email") String email, @RequestParam(value="contactPhone") String contactPhone, BindingResult bindingResult, WebRequest webRequest, ModelAndView model) throws MethodArgumentNotValidException {
        Person person = new Person();
        person.setFirstName(firstName);
        person.setLastName(lastName);
        Email emailPerson = new Email();
        emailPerson.setValue(email);
        person.setEmail(emailPerson);
        Phone phone = new Phone();
        phone.setValue(contactPhone);
        person.setPhone(phone);
        user.setPerson(person);
        HashMap<String, Map<GeneralValidator.Constraint, String>> constraints = new HashMap<String, Map<GeneralValidator.Constraint, String>>();
        GeneralValidator.buildField(constraints, "password", new AbstractMap.SimpleEntry<GeneralValidator.Constraint, Object>(GeneralValidator.Constraint.NOT_NULL_OR_EMPTY, null), new AbstractMap.SimpleEntry<GeneralValidator.Constraint, String>(GeneralValidator.Constraint.MIN, "4"), new AbstractMap.SimpleEntry<GeneralValidator.Constraint, String>(GeneralValidator.Constraint.MATCH_WITH, "confirmPassword"));
        GeneralValidator.buildField(constraints, "person.firstName", new AbstractMap.SimpleEntry<GeneralValidator.Constraint, Object>(GeneralValidator.Constraint.NOT_NULL_OR_EMPTY, null), new AbstractMap.SimpleEntry<GeneralValidator.Constraint, String>(GeneralValidator.Constraint.MIN, "4"));
        GeneralValidator.buildField(constraints, "person.lastName", new AbstractMap.SimpleEntry<GeneralValidator.Constraint, Object>(GeneralValidator.Constraint.NOT_NULL_OR_EMPTY, null), new AbstractMap.SimpleEntry<GeneralValidator.Constraint, String>(GeneralValidator.Constraint.MIN, "4"));
        GeneralValidator.buildField(constraints, "person.emails", new AbstractMap.SimpleEntry<GeneralValidator.Constraint, Object>(GeneralValidator.Constraint.NOT_NULL_OR_EMPTY, null), new AbstractMap.SimpleEntry<GeneralValidator.Constraint, String>(GeneralValidator.Constraint.REGEX, "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$"));
        GeneralValidator.buildField(constraints, "person.phones", new AbstractMap.SimpleEntry<GeneralValidator.Constraint, Object>(GeneralValidator.Constraint.NOT_NULL_OR_EMPTY, null), new AbstractMap.SimpleEntry<GeneralValidator.Constraint, String>(GeneralValidator.Constraint.MIN, "8"));
        if (this.userService.findByUsername(user.getUsername()) != null) {
            bindingResult.reject(null, "username not unique");
        }
        if (this.userService.findByEmail(email) != null) {
            bindingResult.reject(null, "email not unique");
        }
        new GeneralValidator(constraints).invoke(user, bindingResult);
        StaticUtls.encodeUserPassword(user);
        OnceTimeAccessToken token = OnceTimeAccessToken.genToken((User)user, (int)1440, (OnceTimeAccessToken.TokenType)OnceTimeAccessToken.TokenType.VERIFICATION);
        this.onceTimeAccessTokenService.save((Object)token);
        String link = StaticUtls.genLinkConfirmationForOnceTimeAccessToken(token, this.serverName, "registration");
        String to = email;
        String subject = "Registration confirmation in iVIS";
        String text = "Thank you, " + user.getUsername() + " for registration in iVIS. Please follow link to confirm registration: " + link;
        MailSenderUtil mailSenderUtil = new MailSenderUtil(this.mailSender, false, false, this.fromAddress, this.fromUsername);
        mailSenderUtil.createMessage(to, subject, text);
        mailSenderUtil.sendMessage();
        model.setViewName("redirect:/login");
        return model;
    }

    @RequestMapping(value={"/registration/confirm"}, params={"access", "id"}, method={RequestMethod.GET})
    public ModelAndView registrationConfirm(@RequestParam(value="access") String access, @RequestParam(value="id") Long id, WebRequest webRequest, ModelAndView model) {
        OnceTimeAccessToken accessToken = (OnceTimeAccessToken)this.onceTimeAccessTokenService.find((Object)id);
        String message = StaticUtls.checkOnceTimeAccessToken(accessToken, access);
        if (message != null) {
            GeneralError generalError = ErrorBuilder.buildSecurityException(message);
            model.addObject((Object)generalError);
            model.setViewName("errors/error");
            return model;
        }
        User user = (User)accessToken.getUser();
        user.setEnabled(Boolean.valueOf(true));
        Role roleUser = (Role)this.roleService.findFirstByName("ROLE_USER");
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(roleUser);
        user.setRoles(roles);
        Person person = (Person)this.personService.save((Object)user.getPerson());
        user.setPerson(person);
        this.userService.save((Object)user);
        accessToken.setUsed(Boolean.valueOf(true));
        this.onceTimeAccessTokenService.save((Object)accessToken);
        String to = ((Email)user.getPerson().getEmails().get(CommunicationTypeEnum.HOME)).getValue();
        String subject = "Registration complete success";
        String text = "Now you, " + user.getUsername() + " can use iVIS system. You can log in " + this.serverName + "/login using your username and password.";
        MailSenderUtil mailSenderUtil = new MailSenderUtil(this.mailSender, false, false, this.fromAddress, this.fromUsername);
        mailSenderUtil.createMessage(to, subject, text);
        mailSenderUtil.sendMessage();
        model.setViewName("redirect:/login");
        return model;
    }

    @RequestMapping(value={"/registration/emailunique"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean registrationEmailCheck(@RequestParam(value="email") String email, WebRequest webRequest, ModelAndView model) {
        User userByEmail = this.userService.findByEmail(email);
        return userByEmail == null;
    }

    @RequestMapping(value={"/registration/usernameunique"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean registrationUsernameCheck(@RequestParam(value="username") String username, WebRequest webRequest, ModelAndView model) {
        User userByName = this.userService.findByUsername(username);
        return userByName == null;
    }

    @RequestMapping(value={"/restore_password"})
    public ModelAndView restorePassword(WebRequest webRequest, ModelAndView model) {
        model.setViewName("security/restore_password");
        return model;
    }

    @RequestMapping(value={"/restore_password/email"}, method={RequestMethod.POST})
    public ModelAndView restorePasswordEmail(@RequestParam(value="email") String email, WebRequest webRequest, ModelAndView model) {
        User userByEmail = this.userService.findByEmail(email);
        if (userByEmail == null) {
            GeneralError generalError = ErrorBuilder.buildValidationError(Arrays.asList("user with email " + email + " does not exist"));
            model.addObject((Object)generalError);
            model.setViewName("errors/error");
            return model;
        }
        OnceTimeAccessToken accessToken = OnceTimeAccessToken.genToken((User)userByEmail, (int)1440, (OnceTimeAccessToken.TokenType)OnceTimeAccessToken.TokenType.PASSWORD_RESET);
        this.onceTimeAccessTokenService.save((Object)accessToken);
        String link = StaticUtls.genLinkConfirmationForOnceTimeAccessToken(accessToken, this.serverName, "restore_password");
        String to = email;
        String subject = "Restore password in iVIS";
        String text = "Hello, " + userByEmail.getUsername() + ". For restore password in iVIS please follow link  " + link;
        MailSenderUtil mailSenderUtil = new MailSenderUtil(this.mailSender, false, false, this.fromAddress, this.fromUsername);
        mailSenderUtil.createMessage(to, subject, text);
        mailSenderUtil.sendMessage();
        model.setViewName("redirect:/login");
        return model;
    }

    @RequestMapping(value={"/restore_password/confirm"}, params={"access", "id"}, method={RequestMethod.GET})
    public ModelAndView restorePasswordConfirm(@RequestParam(value="access") String access, @RequestParam(value="id") Long id, WebRequest webRequest, ModelAndView model) {
        OnceTimeAccessToken accessToken = (OnceTimeAccessToken)this.onceTimeAccessTokenService.find((Object)id);
        String message = StaticUtls.checkOnceTimeAccessToken(accessToken, access);
        if (message != null) {
            GeneralError generalError = ErrorBuilder.buildSecurityException(message);
            model.addObject((Object)generalError);
            model.setViewName("errors/error");
            return model;
        }
        accessToken.setUsed(Boolean.valueOf(true));
        this.onceTimeAccessTokenService.save((Object)accessToken);
        User user = (User)accessToken.getUser();
        model.addObject("user", (Object)user);
        model.setViewName("security/restore_password");
        return model;
    }

    @RequestMapping(value={"/restore_password/do"}, params={"password", "userId"}, method={RequestMethod.POST})
    public ModelAndView restorePasswordDo(@RequestParam(value="password") String password, @RequestParam(value="confirmPassword") String confirmPassword, @RequestParam(value="userId") Long userId, WebRequest webRequest, ModelAndView model) throws MethodArgumentNotValidException {
        User user = (User)this.userService.find((Object)userId);
        if (user == null) {
            GeneralError generalError = ErrorBuilder.buildValidationError(Arrays.asList("user with id " + userId + " does not exist"));
            model.addObject((Object)generalError);
            model.setViewName("errors/error");
            return model;
        }
        user.setPassword(password);
        user.setConfirmPassword(confirmPassword);
        HashMap<String, Map<GeneralValidator.Constraint, String>> constraints = new HashMap<String, Map<GeneralValidator.Constraint, String>>();
        GeneralValidator.buildField(constraints, "password", new AbstractMap.SimpleEntry<GeneralValidator.Constraint, Object>(GeneralValidator.Constraint.NOT_NULL_OR_EMPTY, null), new AbstractMap.SimpleEntry<GeneralValidator.Constraint, String>(GeneralValidator.Constraint.MIN, "8"), new AbstractMap.SimpleEntry<GeneralValidator.Constraint, String>(GeneralValidator.Constraint.MATCH_WITH, "confirmPassword"));
        BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult((Object)user, "user");
        new GeneralValidator(constraints).invoke(user, (BindingResult)bindingResult);
        StaticUtls.encodeUserPassword(user);
        this.userService.save((Object)user);
        String to = ((Email)user.getPerson().getEmails().get(CommunicationTypeEnum.HOME)).getValue();
        String subject = "Restore password in iVIS";
        String text = "Hello, " + user.getUsername() + ". Your password has bean changed.";
        MailSenderUtil mailSenderUtil = new MailSenderUtil(this.mailSender, false, false, this.fromAddress, this.fromUsername);
        mailSenderUtil.createMessage(to, subject, text);
        mailSenderUtil.sendMessage();
        model.setViewName("redirect:/login");
        return model;
    }

    @RequestMapping(value={"/restore_password/emailunique"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean restorePasswordEmailCheck(@RequestParam(value="email") String email, WebRequest webRequest, ModelAndView model) {
        return this.registrationEmailCheck(email, webRequest, model);
    }

    @RequestMapping(value={"/", "/home", "index"})
    public String home() {
        return "default";
    }

    @RequestMapping(value={"/errorhandler"})
    public void errorHandler(HttpServletRequest request, ModelAndView modelAndView) throws Exception {
        throw (Exception)request.getAttribute("javax.servlet.error.exception");
    }

    @RequestMapping(value={"/errorhandler"}, params={"body"}, method={RequestMethod.GET})
    public ModelAndView errorHandlerWithBody(HttpServletRequest request, ModelAndView modelAndView) throws Exception {
        GeneralError generalError = new GeneralError();
        generalError.setErrorCode(Integer.parseInt(request.getParameter("error_code")));
        generalError.setErrorMessage(request.getParameter("error_message"));
        generalError.setErrorDescription(Arrays.asList(request.getParameter("error_description").split(",")));
        modelAndView.addObject((Object)generalError);
        modelAndView.setViewName("errors/error");
        return modelAndView;
    }

    private void checkResourceOwner(String user, Principal principal) {
        OAuth2Authentication authentication;
        if (principal instanceof OAuth2Authentication && !(authentication = (OAuth2Authentication)principal).isClientOnly() && !user.equals(principal.getName())) {
            throw new AccessDeniedException(String.format("User '%s' cannot obtain tokens for user '%s'", principal.getName(), user));
        }
    }

    public void setTokenServices(ConsumerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setClientDetailsService(IvisClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

