/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.entities.embed.Email;
import com.imcode.entities.enums.CommunicationTypeEnum;
import com.imcode.services.EntityRestProviderInformationService;
import com.imcode.services.MethodRestProviderForEntityService;
import com.imcode.services.RoleService;
import com.imcode.services.UserService;
import com.imcode.utils.CollectionTransferUtil;
import com.imcode.utils.MailSenderUtil;
import com.imcode.utils.StaticUtls;
import com.imcode.validators.GeneralValidator;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/users"})
public class UserController {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="${mail.smtp.from.address}")
    private String fromAddress;
    @Value(value="${mail.smtp.from.username}")
    private String fromUsername;
    @Autowired
    private EntityRestProviderInformationService entityRestProviderInformationService;
    @Autowired
    private MethodRestProviderForEntityService methodRestProviderForEntityService;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView list(ModelAndView model) {
        model.setViewName("users/list");
        model.addObject((Object)this.userService.findAll());
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.GET})
    public ModelAndView updateForm(@PathVariable(value="id") User user, ModelAndView model, WebRequest webRequest) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(user, "Try invoke update form for non exist user");
        User currentUser = StaticUtls.getCurrentUser(webRequest, this.userService);
        if (!currentUser.hasRoles(new String[]{"ROLE_ADMIN"}) && !((Long)user.getId()).equals(currentUser.getId())) {
            model.setViewName("redirect:/");
            return model;
        }
        model.setViewName("users/edit");
        model.addObject((Object)user);
        model.addObject((Object)this.roleService.findAll());
        return model;
    }

    @RequestMapping(params={"form"}, method={RequestMethod.GET})
    public ModelAndView createForm(ModelAndView model) {
        model.setViewName("users/edit");
        model.addObject((Object)this.roleService.findAll());
        User user = new User();
        Role roleUser = (Role)this.roleService.findFirstByName("ROLE_USER");
        model.addObject((Object)user);
        if (roleUser != null) {
            user.setAuthorities(roleUser);
        }
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"perm"}, method={RequestMethod.GET})
    public ModelAndView permissionForm(@PathVariable(value="id") User user, ModelAndView model) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(user, "Try invoke permission form for non exist user");
        model.addObject("identifier", (Object)user.getId());
        model.setViewName("users/permissions");
        model.addObject((Object)this.methodRestProviderForEntityService.findAll());
        model.addObject((Object)this.entityRestProviderInformationService.findAll());
        model.addObject("specify", (Object)"user");
        model.addObject("allowedMethods", new CollectionTransferUtil(this.methodRestProviderForEntityService.findAllowedMethodsByUserId((Long)user.getId())));
        return model;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView create(@ModelAttribute(value="user") @Valid User user, BindingResult bindingResult, ModelAndView model) throws MethodArgumentNotValidException {
        HashMap<String, Map<GeneralValidator.Constraint, String>> constraints = new HashMap<String, Map<GeneralValidator.Constraint, String>>();
        if (this.userService.findByUsername(user.getUsername()) != null) {
            bindingResult.reject(null, "username not unique");
        }
        new GeneralValidator(constraints).invoke(user, bindingResult);
        StaticUtls.encodeUserPassword(user);
        this.userService.save((Object)user);
        model.setViewName("redirect:/users");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    public ModelAndView update(@PathVariable(value="id") User persistUser, @ModelAttribute(value="user") @Valid User user, ModelAndView model) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(user, "Try update non exist user");
        StaticUtls.encodeUserPassword(user);
        try {
            StaticUtls.nullAwareBeanCopy(persistUser, user);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.userService.save((Object)persistUser);
        model.setViewName("redirect:/users");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable(value="id") Long id) throws MethodArgumentNotValidException {
        User user = (User)this.userService.find((Object)id);
        StaticUtls.rejectNullValue(user, "Try delete non exist user");
        this.userService.delete((Object)id);
    }

    @RequestMapping(value={"/{id}"}, params={"passwordchange"}, method={RequestMethod.POST})
    public ModelAndView passwordChange(@PathVariable(value="id") User user, @RequestParam(value="password") String password, ModelAndView model) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(user, "Try change password for non exist user");
        user.setPassword(password);
        StaticUtls.encodeUserPassword(user);
        this.userService.save((Object)user);
        String to = ((Email)user.getPerson().getEmails().get(CommunicationTypeEnum.HOME)).getValue();
        String subject = "Change password in iVIS";
        String text = "Hello, " + user.getUsername() + ". Your password has bean changed.";
        MailSenderUtil mailSenderUtil = new MailSenderUtil(this.mailSender, false, false, this.fromAddress, this.fromUsername);
        mailSenderUtil.createMessage(to, subject, text);
        mailSenderUtil.sendMessage();
        model.setViewName("redirect:/logout.do");
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"checkpassword"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean checkPassword(@PathVariable(value="id") User user, @RequestParam(value="checkpassword") String password) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(user, "Try check password for non exist user");
        String userEncodedPassword = user.getPassword();
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        return encoder.matches((CharSequence)password, userEncodedPassword);
    }

    @RequestMapping(value={"/{id}"}, params={"permit"}, method={RequestMethod.POST})
    public ModelAndView permitMethods(@ModelAttribute(value="allowedMethods") CollectionTransferUtil<String> allowedMethods, @PathVariable(value="id") Long userId, ModelAndView model) throws MethodArgumentNotValidException {
        User user = (User)this.userService.find((Object)userId);
        StaticUtls.rejectNullValue(user, "Try set permissions for non exist user");
        Collection<String> idOfMethods = allowedMethods.getCollection();
        List allowedMethodsByUserId = this.methodRestProviderForEntityService.findAllowedMethodsByUserId(userId);
        allowedMethodsByUserId.stream().peek(methodRestProviderForEntity -> methodRestProviderForEntity.deleteUser(userId)).forEach(arg_0 -> ((MethodRestProviderForEntityService)this.methodRestProviderForEntityService).save(arg_0));
        if (idOfMethods != null) {
            idOfMethods.stream().map(Long::parseLong).map(arg_0 -> ((MethodRestProviderForEntityService)this.methodRestProviderForEntityService).find(arg_0)).peek(methodRestProviderForEntity -> methodRestProviderForEntity.addUser(user)).forEach(arg_0 -> ((MethodRestProviderForEntityService)this.methodRestProviderForEntityService).save(arg_0));
        }
        model.setViewName("redirect:/users");
        return model;
    }
}

