/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.saml2;

import com.imcode.entities.User;
import com.imcode.saml2.FilterConfig;
import com.imcode.saml2.SAMLRequestSender;
import com.imcode.saml2.SAMLResponseVerifier;
import com.imcode.saml2.store.SAMLSessionInfo;
import com.imcode.saml2.store.SAMLSessionManager;
import com.imcode.saml2.utils.OpenSamlBootstrap;
import com.imcode.saml2.utils.SAMLUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SAMLSPFilter
implements Filter {
    private static final String SAML_AUTHN_RESPONSE_PARAMETER_NAME = "SAMLResponse";
    private static Logger log = LoggerFactory.getLogger(SAMLSPFilter.class);
    private FilterConfig filterConfig;
    private SAMLResponseVerifier checkSAMLResponse;
    private SAMLRequestSender samlRequestSender;
    private ApplicationContext context;

    public void init(javax.servlet.FilterConfig config) {
        OpenSamlBootstrap.init();
        this.filterConfig = new FilterConfig(config);
        this.checkSAMLResponse = new SAMLResponseVerifier();
        this.samlRequestSender = new SAMLRequestSender();
        this.context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.isFilteredRequest(request) || !this.filterConfig.isEnabled().booleanValue()) {
            log.debug("According to {} configuration parameter request is ignored + {}", new Object[]{"excludedUrlPattern", request.getRequestURI()});
            chain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (SAMLSPFilter.getCurrentUser() != null) {
            return;
        }
        log.debug("Attempt to secure resource  is intercepted : {}", (Object)((HttpServletRequest)servletRequest).getRequestURL().toString());
        String responseMessage = servletRequest.getParameter(SAML_AUTHN_RESPONSE_PARAMETER_NAME);
        if (responseMessage != null) {
            log.debug("Response from Identity Provider is received");
            try {
                log.debug("Decoding of SAML message");
                SAMLMessageContext samlMessageContext = SAMLUtils.decodeSamlMessage((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
                log.debug("SAML message has been decoded successfully");
                samlMessageContext.setLocalEntityId(this.filterConfig.getSpProviderId());
                this.checkSAMLResponse.verify((SAMLMessageContext<Response, SAMLObject, NameID>)samlMessageContext);
                log.debug("Starting and store SAML session..");
                SAMLSessionManager.getInstance().createSAMLSession(request, response, (SAMLMessageContext<Response, SAMLObject, NameID>)samlMessageContext);
                SAMLSessionInfo samlSessionInfo = SAMLSessionManager.getInstance().getSAMLSession(request.getSession());
                SAMLSessionManager.getInstance().loginUser(samlSessionInfo, request, response);
                return;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (this.getCorrectURL(request).equals(this.filterConfig.getLogoutUrl())) {
            log.debug("Logout action: destroying SAML session.");
            SAMLSessionManager.getInstance().destroySAMLSession(request.getSession());
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (SAMLSessionManager.getInstance().isSAMLSessionValid(request.getSession())) {
            SAMLSessionInfo samlSessionInfo = SAMLSessionManager.getInstance().getSAMLSession(request.getSession());
            SAMLSessionManager.getInstance().loginUser(samlSessionInfo, request, response);
            log.debug("SAML session exists and valid: grant access to secure resource");
            return;
        }
        log.debug("Sending authentication request to idP");
        try {
            this.samlRequestSender.sendSAMLAuthRequest(request, response, this.filterConfig.getSpProviderId(), this.filterConfig.getAcsUrl(), this.filterConfig.getIdpSSOUrl());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean isFilteredRequest(HttpServletRequest request) {
        return this.filterConfig.getExcludedUrlPattern() == null || !this.getCorrectURL(request).matches(this.filterConfig.getExcludedUrlPattern());
    }

    private String getCorrectURL(HttpServletRequest request) {
        String url;
        String contextPath = request.getContextPath();
        String requestUri = request.getRequestURI();
        int contextBeg = requestUri.indexOf(contextPath);
        int contextEnd = contextBeg + contextPath.length();
        String slash = "/";
        String string = url = contextBeg < 0 || contextEnd == requestUri.length() - 1 ? requestUri : requestUri.substring(contextEnd);
        if (!url.startsWith(slash)) {
            url = slash + url;
        }
        return url;
    }

    public void destroy() {
        log = null;
    }

    public static User getCurrentUser() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            Object principal = authentication.getPrincipal();
            return principal instanceof User ? (User)principal : null;
        }
        return null;
    }
}

