/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Incident;
import com.imcode.entities.Issue;
import com.imcode.services.IncidentService;
import com.imcode.services.IssueService;
import com.imcode.services.UserService;
import com.imcode.utils.StaticUtls;
import com.imcode.validators.GenericValidator;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}/issues"})
public class IssueRestControllerImpl
extends AbstractRestController<Issue, Long, IssueService> {
    @Autowired
    IssueService issueService;
    @Autowired
    IncidentService incidentService;
    @Autowired
    UserService userService;

    @Override
    public Object create(@RequestBody @Valid Issue entity, HttpServletResponse response, BindingResult bindingResult, WebRequest webRequest) throws MethodArgumentNotValidException {
        new GenericValidator(true, "reportDay", "reportedBy").invoke(entity, bindingResult);
        Set<Incident> incidentsMerged = this.mergeIncidents(entity.getIncidents());
        entity.setIncidents(incidentsMerged);
        entity.setReportDay(new Date());
        entity.setReportedBy(StaticUtls.getCurrentUser(webRequest, this.userService).getPerson());
        Issue issue = (Issue)this.issueService.save((Object)entity);
        this.saveIncidents(incidentsMerged, issue);
        return issue;
    }

    @RequestMapping(method={RequestMethod.GET}, params={"search_text", "order_by"})
    public Object findByCriteria(@RequestParam(value="search_text") String searchText, @RequestParam(value="order_by") String orderBy, WebRequest webRequest) {
        if (orderBy.equals("title")) {
            return this.issueService.findBySearchCriteria(searchText, orderBy);
        }
        return null;
    }

    private Set<Incident> mergeIncidents(Set<Incident> incidents) {
        return incidents.stream().map(incident -> {
            Incident incidentSaved = (Incident)this.incidentService.find((Object)incident.getId());
            try {
                StaticUtls.nullAwareBeanCopy(incidentSaved, incident);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return incidentSaved;
        }).collect(Collectors.toSet());
    }

    private void saveIncidents(Set<Incident> incidents, Issue issue) {
        this.incidentService.save((Iterable)incidents.stream().peek(incident -> incident.setIssue(issue)).collect(Collectors.toSet()));
    }

    @Override
    protected Map<String, Map<GenericValidator.Constraint, String>> getFieldsConstraints() {
        Map<String, Map<GenericValidator.Constraint, String>> fieldsConstraints = super.getFieldsConstraints();
        GenericValidator.buildField(fieldsConstraints, "title", new AbstractMap.SimpleEntry<GenericValidator.Constraint, Object>(GenericValidator.Constraint.NOT_NULL_OR_EMPTY, null), new AbstractMap.SimpleEntry<GenericValidator.Constraint, String>(GenericValidator.Constraint.MIN, "4"));
        GenericValidator.buildField(fieldsConstraints, "description", new AbstractMap.SimpleEntry<GenericValidator.Constraint, Object>(GenericValidator.Constraint.NOT_NULL_OR_EMPTY, null), new AbstractMap.SimpleEntry<GenericValidator.Constraint, String>(GenericValidator.Constraint.MIN, "4"));
        GenericValidator.buildField(fieldsConstraints, "status", new AbstractMap.SimpleEntry<GenericValidator.Constraint, Object>(GenericValidator.Constraint.NOT_NULL_OR_EMPTY, null));
        GenericValidator.buildField(fieldsConstraints, "responsiblePerson", new AbstractMap.SimpleEntry<GenericValidator.Constraint, Object>(GenericValidator.Constraint.NOT_NULL_OR_EMPTY, null));
        GenericValidator.buildField(fieldsConstraints, "authorizedPersons", new AbstractMap.SimpleEntry<GenericValidator.Constraint, Object>(GenericValidator.Constraint.NOT_NULL_OR_EMPTY, null));
        GenericValidator.buildField(fieldsConstraints, "incidents", new AbstractMap.SimpleEntry<GenericValidator.Constraint, Object>(GenericValidator.Constraint.NOT_NULL_OR_EMPTY, null));
        return fieldsConstraints;
    }
}

