/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.School;
import com.imcode.entities.enums.ServiceTypeEnum;
import com.imcode.services.SchoolService;
import com.imcode.utils.StaticUtls;
import com.imcode.validators.GenericValidator;
import java.util.Arrays;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/schools"})
public class SchoolController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String MAIN_PATH = "schools";
    @Autowired
    private SchoolService mainService;
    @Autowired
    MessageSource messageSource;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView list(ModelAndView model) {
        model.setViewName("schools/list");
        model.addObject("entityList", (Object)this.mainService.findAll());
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.GET})
    public ModelAndView updateForm(@PathVariable(value="id") School entity, ModelAndView model) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(entity, "try invoke update form for non exist school");
        this.addSpecialObjects(model, entity);
        model.setViewName("schools/edit");
        model.addObject("entity", (Object)entity);
        return model;
    }

    @RequestMapping(params={"form"}, method={RequestMethod.GET})
    public ModelAndView createForm(ModelAndView model) {
        School entity = new School();
        this.addSpecialObjects(model, entity);
        model.setViewName("schools/edit");
        model.addObject("entity", (Object)entity);
        return model;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView create(@ModelAttribute(value="entity") @Valid School entity, ModelAndView model) throws MethodArgumentNotValidException {
        BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult((Object)entity, "pupil");
        new GenericValidator(true, "id").invoke(entity, (BindingResult)bindingResult);
        this.addSpecialObjects(model, entity);
        this.mainService.save((Object)entity);
        model.setViewName("redirect:/schools");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    public ModelAndView update(@PathVariable(value="id") School persistEntity, @ModelAttribute(value="entity") @Valid School entity, ModelAndView model) throws MethodArgumentNotValidException {
        StaticUtls.rejectNullValue(persistEntity, "Try update non exist school");
        this.addSpecialObjects(model, entity);
        String[] fieldExceptions = new String[]{"id"};
        BeanUtils.copyProperties((Object)entity, (Object)persistEntity, (String[])fieldExceptions);
        this.mainService.save((Object)persistEntity);
        model.setViewName("redirect:/schools");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable(value="id") Long id) throws MethodArgumentNotValidException {
        School school = (School)this.mainService.find((Object)id);
        StaticUtls.rejectNullValue(school, "Try delete non exist school");
        this.mainService.delete((Object)id);
    }

    protected void addSpecialObjects(ModelAndView model, School entity) {
        model.addObject("serviceTypeList", Arrays.asList(ServiceTypeEnum.values()));
    }
}

