/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.validators;

import com.imcode.entities.superclasses.AbstractIdEntity;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.MethodArgumentNotValidException;

public class GenericValidator
implements Validator {
    public static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    public static final String URL_PATTERN = "^http(s{0,1})://[a-zA-Z0-9_/\\-\\.]+\\.([A-Za-z/]{2,5})[a-zA-Z0-9_/\\&\\?\\=\\-\\.\\~\\%]*";
    private Map<String, Map<Constraint, String>> fieldsConstraints;

    public GenericValidator(Map<String, Map<Constraint, String>> fieldsConstraints) {
        this.fieldsConstraints = fieldsConstraints;
    }

    public GenericValidator(boolean isNull, String ... nullFields) {
        this.fieldsConstraints = new HashMap<String, Map<Constraint, String>>();
        for (String nullField : nullFields) {
            GenericValidator.buildField(this.fieldsConstraints, nullField, new AbstractMap.SimpleEntry<Constraint, Object>(isNull ? Constraint.NULL : Constraint.NOT_NULL_OR_EMPTY, null));
        }
    }

    public boolean supports(Class<?> clazz) {
        return AbstractIdEntity.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        Set<String> fields = this.fieldsConstraints.keySet();
        for (String field : fields) {
            Map<Constraint, String> constraints = this.fieldsConstraints.get(field);
            for (Constraint constraintName : constraints.keySet()) {
                String value = constraints.get((Object)constraintName);
                switch (constraintName) {
                    case NOT_NULL_OR_EMPTY: {
                        this.checkNotNullOrEmpty(errors, field);
                        break;
                    }
                    case NULL: {
                        this.checkNull(errors, field);
                        break;
                    }
                    case MAX: {
                        this.checkMax(errors, field, value);
                        break;
                    }
                    case MIN: {
                        this.checkMin(errors, field, value);
                        break;
                    }
                    case REGEX: {
                        this.checkRegex(errors, field, value);
                        break;
                    }
                    case MATCH_WITH: {
                        this.checkMatchWith(errors, field, value);
                    }
                }
            }
        }
    }

    @SafeVarargs
    public static void buildField(Map<String, Map<Constraint, String>> fields, String name, AbstractMap.SimpleEntry<Constraint, String> ... constraints) {
        HashMap<Constraint, String> constraintsResult = new HashMap<Constraint, String>();
        for (AbstractMap.SimpleEntry<Constraint, String> constraint : constraints) {
            constraintsResult.put(constraint.getKey(), constraint.getValue());
        }
        fields.put(name, constraintsResult);
    }

    public void invoke(Object entity, BindingResult bindingResult) throws MethodArgumentNotValidException {
        this.validate(entity, (Errors)bindingResult);
        if (bindingResult.hasErrors()) {
            throw new MethodArgumentNotValidException(null, bindingResult);
        }
    }

    private void checkNotNullOrEmpty(Errors errors, String field) {
        Object fieldValue = errors.getFieldValue(field);
        if (fieldValue == null) {
            errors.rejectValue(field, null, field + " can not be null");
        } else if (fieldValue instanceof Collection && ((Collection)fieldValue).isEmpty()) {
            errors.rejectValue(field, null, field + " can not be empty or null");
        }
    }

    private void checkNull(Errors errors, String field) {
        Object fieldValue = errors.getFieldValue(field);
        if (fieldValue != null) {
            errors.rejectValue(field, null, field + " must be ignored");
        }
    }

    private void checkMax(Errors errors, String field, String value) {
        Object fieldValue = errors.getFieldValue(field);
        if (fieldValue instanceof Number && value.compareTo(fieldValue.toString()) < 0) {
            errors.rejectValue(field, null, field + " can not be more than " + value);
        }
        if (fieldValue instanceof String && fieldValue.toString().length() > Integer.parseInt(value)) {
            errors.rejectValue(field, null, field + " lenght can not be more than " + value);
        }
    }

    private void checkMin(Errors errors, String field, String value) {
        Object fieldValue = errors.getFieldValue(field);
        if (fieldValue instanceof Number && value.compareTo(fieldValue.toString()) > 0) {
            errors.rejectValue(field, null, field + " can not be less than " + value);
        }
        if (fieldValue instanceof String && fieldValue.toString().length() < Integer.parseInt(value)) {
            errors.rejectValue(field, null, field + " lenght can not be less than " + value);
        }
    }

    private void checkRegex(Errors errors, String field, String value) {
        Object fieldValue = errors.getFieldValue(field);
        if (fieldValue != null) {
            String determiner = "";
            switch (value) {
                case "^http(s{0,1})://[a-zA-Z0-9_/\\-\\.]+\\.([A-Za-z/]{2,5})[a-zA-Z0-9_/\\&\\?\\=\\-\\.\\~\\%]*": {
                    determiner = "URL";
                    break;
                }
                case "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$": {
                    determiner = "email";
                }
            }
            if (!fieldValue.toString().matches(value)) {
                errors.rejectValue(field, null, field + " does not match with " + determiner + " pattern");
            }
        }
    }

    private void checkMatchWith(Errors errors, String field, String value) {
        Object fieldValue = errors.getFieldValue(field);
        if (fieldValue != null) {
            Object forCheck = errors.getFieldValue(value);
            if (!fieldValue.toString().equals(forCheck.toString())) {
                errors.rejectValue(field, null, field + " does not match with " + value);
            }
        }
    }

    public static enum Constraint {
        NOT_NULL_OR_EMPTY,
        MAX,
        MIN,
        REGEX,
        MATCH_WITH,
        NULL;

    }
}

