/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.security.interceptors;

import com.imcode.entities.MethodRestProviderForEntity;
import com.imcode.entities.User;
import com.imcode.services.MethodRestProviderForEntityService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AccessApiInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private MethodRestProviderForEntityService methodRestProviderForEntityService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof OAuth2Authentication)) {
            response.setStatus(401);
            return false;
        }
        OAuth2Authentication oauth2Authentication = (OAuth2Authentication)authentication;
        OAuth2Request clientAuthentication = oauth2Authentication.getOAuth2Request();
        String clientId = clientAuthentication.getClientId();
        Long userId = (Long)((User)oauth2Authentication.getUserAuthentication().getPrincipal()).getId();
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        String controllerSimpleName = handlerMethod.getBean().getClass().getSimpleName();
        String entityName = controllerSimpleName.substring(0, controllerSimpleName.indexOf("RestControllerImpl"));
        String methodName = handlerMethod.getMethod().getName();
        MethodRestProviderForEntity allowedMethod = this.methodRestProviderForEntityService.findAllowedMethod(methodName, entityName, clientId, userId);
        if (allowedMethod == null) {
            response.setStatus(403);
            return false;
        }
        return true;
    }
}

