/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.exceptions.factories;

import com.imcode.exceptions.wrappers.GeneralError;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.Errors;

public class ErrorBuilder {
    public static GeneralError buildValidationError(Errors errors) {
        GeneralError generalError = new GeneralError();
        generalError.setErrorCode(1001);
        int errorCount = errors.getErrorCount();
        generalError.setErrorMessage("Validation failed. " + errorCount + " error" + (errorCount > 1 ? "s" : ""));
        List errorDescription = errors.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toCollection(LinkedList::new));
        generalError.setErrorDescription(errorDescription);
        return generalError;
    }

    public static GeneralError buildDatabasePersistenceError(Exception e) {
        return ErrorBuilder.buildException(e, 2001);
    }

    public static GeneralError buildJsonMappingException(Exception e) {
        return ErrorBuilder.buildException(e, 3001);
    }

    public static GeneralError buildUncaughtException(Exception e) {
        return ErrorBuilder.buildException(e, 4001);
    }

    private static GeneralError buildException(Exception e, int errorCode) {
        GeneralError generalError = new GeneralError();
        generalError.setErrorCode(errorCode);
        String message = null;
        switch (errorCode) {
            case 2001: {
                message = "Database level error";
                break;
            }
            case 3001: {
                message = "JSON level error";
                break;
            }
            case 4001: {
                message = "Uncaught error";
            }
        }
        generalError.setErrorMessage(message);
        String cause = e.getCause().toString();
        List<String> errorDescription = Arrays.asList(cause);
        generalError.setErrorDescription(errorDescription);
        return generalError;
    }
}

