/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.EntityRestProviderInformation;
import com.imcode.entities.MethodRestProviderForEntity;
import com.imcode.entities.User;
import com.imcode.entities.oauth2.JpaClientDetails;
import com.imcode.oauth2.IvisClientDetailsService;
import com.imcode.services.EntityRestProviderInformationService;
import com.imcode.services.MethodRestProviderForEntityService;
import com.imcode.services.OnceTimeAccessTokenService;
import com.imcode.services.UserService;
import com.imcode.utils.ControllerReflectionUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class OnStartupController {
    @Autowired
    public OnceTimeAccessTokenService onceTimeAccessTokenService;
    @Autowired
    private MethodRestProviderForEntityService methodRestProviderForEntityService;
    @Autowired
    private EntityRestProviderInformationService entityRestProviderInformationService;
    @Autowired
    private IvisClientDetailsService clientDetailsService;
    @Autowired
    private UserService userService;

    @PostConstruct
    public void deleteExpiredOrUsedOnceTimeAccessTokens() {
        List onceTimeAccessTokens = this.onceTimeAccessTokenService.selectExpiredOrUsedTokens();
        this.onceTimeAccessTokenService.delete((Iterable)onceTimeAccessTokens);
    }

    @PostConstruct
    public void updateInformationAboutServices() {
        List allInfo = this.entityRestProviderInformationService.findAll();
        this.methodRestProviderForEntityService.deleteAll();
        this.entityRestProviderInformationService.deleteAll();
        Set<Class<? extends Object>> restControllerClasses = ControllerReflectionUtil.getAllClassesFromPackage("com.imcode.controllers.restful");
        for (Class<? extends Object> clazz : restControllerClasses) {
            ControllerReflectionUtil util = new ControllerReflectionUtil(clazz);
            EntityRestProviderInformation entityRestProviderInformation = new EntityRestProviderInformation();
            entityRestProviderInformation.setRestControllerClass(clazz);
            entityRestProviderInformation.setEntityClass(util.getEntityName());
            EntityRestProviderInformation savedInfo = (EntityRestProviderInformation)this.entityRestProviderInformationService.save((Object)entityRestProviderInformation);
            Set<Method> methods = util.getMethodsWithRequestMappingAnnotation();
            Set methodsForPersist = methods.stream().map(method -> util.buildPersistenceMethodOf((Method)method, savedInfo)).collect(Collectors.toSet());
            this.methodRestProviderForEntityService.save(methodsForPersist);
        }
        for (EntityRestProviderInformation info : allInfo) {
            EntityRestProviderInformation persistInfoByEntityClass = this.entityRestProviderInformationService.findByEntityClass(info.getEntityClass());
            if (persistInfoByEntityClass == null) continue;
            Set entityProviderMethods = info.getEntityProviderMethods();
            for (MethodRestProviderForEntity entityProviderMethod : entityProviderMethods) {
                MethodRestProviderForEntity methodForCheck;
                Optional<MethodRestProviderForEntity> methodForCheckOptional = persistInfoByEntityClass.getEntityProviderMethods().stream().filter(method -> entityProviderMethod.getName().equals(method.getName())).findFirst();
                if (!methodForCheckOptional.isPresent() || !(methodForCheck = methodForCheckOptional.get()).equals((Object)entityProviderMethod)) continue;
                Set users = entityProviderMethod.getUsers().stream().peek(user -> new User().setId(user.getId())).collect(Collectors.toSet());
                methodForCheck.setUsers(users);
                Set clients = entityProviderMethod.getClients().stream().peek(clientDetails -> new JpaClientDetails().setClientId(clientDetails.getClientId())).collect(Collectors.toSet());
                methodForCheck.setClients(clients);
                this.methodRestProviderForEntityService.save((Object)methodForCheck);
            }
        }
    }
}

