/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.utils;

import com.imcode.entities.EntityRestProviderInformation;
import com.imcode.entities.MethodRestProviderForEntity;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class ControllerReflectionUtil {
    private static final String API_PATH = "/api/v1/{format}";
    private static final String ENTITY_PACKAGE = "com.imcode.entities";
    public static final String REST_CONTROLLERS_PACKAGE = "com.imcode.controllers.restful";
    private Class<?> controllerClass;
    private String controllerPath;
    private String entityName;
    private Method method;

    public ControllerReflectionUtil(Class<?> controllerClass) {
        this.controllerClass = controllerClass;
        this.genAndSetControllerPathAndEntityName();
    }

    public MethodRestProviderForEntity buildPersistenceMethodOf(Method method, EntityRestProviderInformation savedInfo) {
        MethodRestProviderForEntity methodForPersist = new MethodRestProviderForEntity();
        methodForPersist.setEntityRestProviderInformation(savedInfo);
        methodForPersist.setName(this.getNameOf(method));
        methodForPersist.setUrl(this.controllerPath + this.getUrlOf(method));
        methodForPersist.setRequestMethod(this.getRequestMethodOf(method));
        methodForPersist.setInParameters(this.getInParametersOf(method));
        methodForPersist.setOutParameter(this.getOutParameterOf(method));
        return methodForPersist;
    }

    public Set<Method> getMethodsWithRequestMappingAnnotation() {
        Set<Method> declaredMethods = this.getAllMethodFromContrllerAndSuperClass();
        Set<Method> requestMapping = declaredMethods.stream().filter(method -> AnnotationUtils.findAnnotation((Method)method, RequestMapping.class) != null).filter(this.distinctByKey(Method::getName)).collect(Collectors.toSet());
        return requestMapping;
    }

    public String getControllerPath() {
        return this.controllerPath;
    }

    public String getEntityClass() {
        return "com.imcode.entities." + this.entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    private void genAndSetControllerPathAndEntityName() {
        String simpleName = this.controllerClass.getSimpleName();
        if (!simpleName.contains("RestControllerImpl")) {
            System.out.println();
        }
        this.entityName = simpleName.substring(0, simpleName.indexOf("RestControllerImpl"));
        this.controllerPath = "/api/v1/{format}/" + this.entityNameToLowerCaseInPluralForm(this.entityName);
    }

    private Set<Method> getAllMethodFromContrllerAndSuperClass() {
        LinkedHashSet<Method> declaredMethods = new LinkedHashSet<Method>();
        Collections.addAll(declaredMethods, this.controllerClass.getMethods());
        return declaredMethods;
    }

    public static Set<Class<? extends Object>> getAllClassesFromPackage(String packageName) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(".*")));
        Set classes = provider.findCandidateComponents(packageName);
        Set<Class<? extends Object>> allClasses = classes.stream().map(bean -> {
            try {
                return Class.forName(bean.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toSet());
        return allClasses;
    }

    private String getNameOf(Method method) {
        return method.getName();
    }

    private String getUrlOf(Method method) {
        HashSet values = new HashSet();
        Collections.addAll(values, ((RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class)).value());
        Optional<String> url = values.stream().filter(value -> value.contains("/")).findFirst();
        return url.isPresent() ? url.get() : "";
    }

    private RequestMethod getRequestMethodOf(Method method) {
        return ((RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class)).method()[0];
    }

    private String getOutParameterOf(Method method) {
        return this.genReturnTypeByMethodName(method.getName());
    }

    private Map<String, String> getInParametersOf(Method method) {
        String[] allParameterNames = new DefaultParameterNameDiscoverer().getParameterNames(method);
        return IntStream.range(0, method.getParameterCount() - 1).mapToObj(i -> new MethodParameter(method, i)).filter(methodParameter -> methodParameter.hasParameterAnnotation(PathVariable.class) || methodParameter.hasParameterAnnotation(RequestParam.class) || methodParameter.hasParameterAnnotation(RequestBody.class)).collect(Collectors.toMap(methodParameter -> this.resolveMethodParameterName((MethodParameter)methodParameter, allParameterNames), methodParameter -> this.resolveMethodParameterType((MethodParameter)methodParameter)));
    }

    private String resolveMethodParameterName(MethodParameter methodParameter, String[] allParameterNames) {
        if (methodParameter.hasParameterAnnotation(PathVariable.class)) {
            String value = ((PathVariable)methodParameter.getParameterAnnotation(PathVariable.class)).value();
            return value.isEmpty() ? allParameterNames[methodParameter.getParameterIndex()] : value;
        }
        if (methodParameter.hasParameterAnnotation(RequestParam.class)) {
            String value = ((RequestParam)methodParameter.getParameterAnnotation(RequestParam.class)).value();
            return value.isEmpty() ? allParameterNames[methodParameter.getParameterIndex()] : value;
        }
        if (this.resolveMethodParameterType(methodParameter).equals(this.entityName)) {
            return StringUtils.uncapitalize((String)this.entityName);
        }
        return this.inPluralForm(StringUtils.uncapitalize((String)this.entityName));
    }

    private String resolveMethodParameterType(MethodParameter methodParameter) {
        String methodTypeSimpleName;
        switch (methodTypeSimpleName = methodParameter.getParameterType().getSimpleName()) {
            case "Serializable": {
                return "Number";
            }
            case "Iterable": {
                return "Array(" + this.entityName + ")";
            }
            case "Object": {
                return "Object(" + this.entityName + ")";
            }
            case "JpaEntity": {
                return "Object(" + this.entityName + ")";
            }
        }
        return methodTypeSimpleName;
    }

    private String entityNameToLowerCaseInPluralForm(String entityName) {
        return this.inPluralForm(entityName.toLowerCase());
    }

    private String inPluralForm(String word) {
        StringBuilder modifiedEntityName = new StringBuilder(word);
        char lastLater = modifiedEntityName.charAt(modifiedEntityName.length() - 1);
        switch (lastLater) {
            case 'y': {
                modifiedEntityName.deleteCharAt(modifiedEntityName.length() - 1).append("ies");
                break;
            }
            case 's': {
                modifiedEntityName.append("es");
                break;
            }
            default: {
                modifiedEntityName.append('s');
            }
        }
        return modifiedEntityName.toString();
    }

    private String genReturnTypeByMethodName(String methodName) {
        boolean isMatch = methodName.matches("(?i)(.*)" + this.entityNameToLowerCaseInPluralForm(this.entityName) + "(.*)|((?i).*)all(.*)");
        return isMatch ? "Array(" + this.entityName + ")" : "Object(" + this.entityName + ")";
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

