/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.utils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailSenderUtil {
    private JavaMailSender mailSender;
    private MimeMessage mimeMessage;
    private MimeMessageHelper helper;
    private boolean html;
    private boolean multipart;
    private String mailTo;
    private String mailSubject;
    private String mailText;
    private Map<String, File> attachements;

    public MailSenderUtil(JavaMailSender mailSender, boolean multipart, boolean html) {
        this.mailSender = mailSender;
        this.mimeMessage = mailSender.createMimeMessage();
        try {
            this.helper = new MimeMessageHelper(this.mimeMessage, multipart, "utf-8");
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        this.html = html;
        this.multipart = multipart;
    }

    public void createMessage(String mailTo, String mailSubject, String mailText) {
        try {
            this.helper.setTo(mailTo);
            this.helper.setSubject(mailSubject);
            this.helper.setText(mailText, this.html);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    public void createMessage() {
        try {
            this.helper.setTo(this.mailTo);
            this.helper.setSubject(this.mailSubject);
            this.helper.setText(this.mailText, this.html);
            if (this.multipart) {
                this.attachements.forEach((name, file) -> {
                    try {
                        this.helper.addAttachment(name, file);
                    }
                    catch (MessagingException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    public void sendMessage() {
        this.mailSender.send(this.mimeMessage);
    }

    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public void setMailText(String mailText) {
        this.mailText = mailText;
    }

    public void attachFile(File file) {
        if (this.attachements == null) {
            this.attachements = new HashMap<String, File>();
        }
        this.attachements.put(file.getName(), file);
    }
}

