/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html.tags;

import com.imcode.entities.interfaces.JpaEntity;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.springframework.util.ReflectionUtils;

public class EntityListTable
extends BodyTagSupport {
    private Iterable<JpaEntity> entities;
    private static final String DEFAULT_DELIMETERS = ",.; ";
    private Iterator<JpaEntity> entityIterator;
    private String columns;
    private Set<String> columnSet;

    public int doStartTag() throws JspException {
        this.entityIterator = this.entities.iterator();
        String[] strings = this.columns.split("[,.; ]+");
        this.columnSet = new LinkedHashSet<String>();
        StringBuilder sb = new StringBuilder().append("<div>").append("<table cellpadding=\"0\" cellspacing=\"0\">").append("<thead>").append("</tr>");
        for (String columnName : strings) {
            this.columnSet.add(columnName);
            sb.append("<th>").append(columnName.toUpperCase()).append("</th>");
        }
        sb.append("<th>&nbsp;</th>");
        sb.append("</tr>").append("</thead>");
        while (this.entityIterator.hasNext()) {
            JpaEntity entity = this.entityIterator.next();
            sb.append("<tr>");
            for (String columnName : this.columnSet) {
                sb.append("<td>");
                Object value = EntityListTable.getFieldValue(entity, columnName);
                sb.append(value);
                sb.append("</td>");
            }
            sb.append("<td class=\"buttons\">").append("<a class=\"button positive\" href=\"" + entity.getClass().getSimpleName() + "/" + entity.getId() + "?form\">Edit</a>").append("<button class=\"negative\" type=\"button\" onclick=\"deleteElement('/" + entity.getClass().getSimpleName() + "'," + entity.getId() + ")\">Remove</button>").append("</td>");
            sb.append("</tr>");
        }
        try {
            this.pageContext.getOut().write(sb.toString());
        }
        catch (IOException e) {
            throw new JspTagException(e.getMessage());
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        if (this.entityIterator.hasNext()) {
            JpaEntity entity = this.entityIterator.next();
            StringBuilder sb = new StringBuilder("<tr>");
            for (String columnName : this.columnSet) {
                sb.append("<td>");
                Object value = EntityListTable.getFieldValue(entity, columnName);
                sb.append(value);
                sb.append("</td>");
            }
            sb.append("</tr>");
            try {
                this.pageContext.getOut().println(sb.toString());
            }
            catch (IOException e) {
                throw new JspTagException(e.getMessage());
            }
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        StringBuilder sb = new StringBuilder("</table>").append("</div>");
        try {
            this.pageContext.getOut().write(sb.toString());
        }
        catch (IOException e) {
            throw new JspTagException(e.getMessage());
        }
        return 0;
    }

    public Iterable<JpaEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(Iterable<JpaEntity> entities) {
        this.entities = entities;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    protected static Object getFieldValue(Object obj, String fieldName) {
        Object result = null;
        Class<?> clazz = obj.getClass();
        Field field = ReflectionUtils.findField(clazz, (String)fieldName);
        if (field == null) {
            throw new RuntimeException("There is no field \"" + fieldName + "\" in class \"" + clazz + "\"");
        }
        ReflectionUtils.makeAccessible((Field)field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

