/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.services;

import com.imcode.services.GenericService;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractService<T, ID extends Serializable, REPOSITORY_TYPE extends JpaRepository<T, ID>>
implements GenericService<T, ID> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="messages")
    protected MessageSource messageSource;
    @Autowired
    protected REPOSITORY_TYPE repo;

    @Transactional
    public T save(T entity) {
        return (T)this.repo.saveAndFlush(entity);
    }

    @Transactional(readOnly=true)
    public T find(ID id) {
        return (T)this.repo.findOne(id);
    }

    public boolean exist(ID id) {
        return this.repo.exists(id);
    }

    @Transactional
    public void delete(ID id) {
        this.repo.delete(id);
    }

    @Transactional(readOnly=true)
    public List<T> findAll() {
        return this.repo.findAll();
    }

    @Transactional
    public T saveWithoutFlush(T entity) {
        return (T)this.repo.save(entity);
    }

    @Transactional
    public void flush() {
        this.repo.flush();
    }

    @Transactional
    public Iterable<T> save(Iterable<T> entities) {
        return this.repo.save(entities);
    }

    public REPOSITORY_TYPE getRepo() {
        return this.repo;
    }

    public void setRepo(REPOSITORY_TYPE repo) {
        this.repo = repo;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }
}

