/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Application;
import com.imcode.entities.User;
import com.imcode.exceptions.MessagingException;
import com.imcode.services.ApplicationService;
import java.security.Principal;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}/applications"})
public class ApplicationRestControllerImpl
extends AbstractRestController<Application, Long, ApplicationService> {
    @Override
    public Object create(@RequestBody Application entity, WebRequest webRequest) throws MessagingException {
        Principal principal = webRequest.getUserPrincipal();
        if (principal instanceof User) {
            entity.setSubmittedUser((User)principal);
        } else if (principal instanceof OAuth2Authentication) {
            entity.setSubmittedUser((User)((OAuth2Authentication)principal).getPrincipal());
        }
        return super.create(entity, webRequest);
    }

    @Override
    public Object update(@PathVariable(value="id") Long aLong, @RequestBody(required=false) Application entity, WebRequest webRequest) {
        if (entity.getId() != null && entity.getLoadedValues() == null) {
            Application attachetEntity = (Application)((ApplicationService)this.getService()).find((Object)entity.getId());
            entity.setLoadedValues(attachetEntity.getLoadedValues());
        }
        return super.update(aLong, entity, webRequest);
    }
}

