/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.saml2;

import com.imcode.saml2.store.SAMLRequestStore;
import com.imcode.saml2.utils.SAMLUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLResponseVerifier {
    private static Logger log = LoggerFactory.getLogger(SAMLResponseVerifier.class);
    private SAMLRequestStore samlRequestStore = SAMLRequestStore.getInstance();

    public void verify(SAMLMessageContext<Response, SAMLObject, NameID> samlMessageContext) throws SAMLException {
        Response samlResponse = (Response)samlMessageContext.getInboundSAMLMessage();
        log.debug("SAML Response message : {}", (Object)SAMLUtils.SAMLObjectToString((XMLObject)samlResponse));
        this.verifyInResponseTo(samlResponse);
        Status status = samlResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        String statusCodeURI = statusCode.getValue();
        if (!statusCodeURI.equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            log.warn("Incorrect SAML message code : {} ", (Object)statusCode.getStatusCode().getValue());
            throw new SAMLException("Incorrect SAML message code : " + statusCode.getValue());
        }
        if (samlResponse.getAssertions().size() == 0) {
            log.error("Response does not contain any acceptable assertions");
            throw new SAMLException("Response does not contain any acceptable assertions");
        }
        Assertion assertion = (Assertion)samlResponse.getAssertions().get(0);
        NameID nameId = assertion.getSubject().getNameID();
        if (nameId == null) {
            log.error("Name ID not present in subject");
            throw new SAMLException("Name ID not present in subject");
        }
        log.debug("SAML authenticated user " + nameId.getValue());
        this.verifyConditions(assertion.getConditions(), samlMessageContext);
    }

    private void verifyInResponseTo(Response samlResponse) {
        String key = samlResponse.getInResponseTo();
        if (!this.samlRequestStore.exists(key)) {
            log.error("Response does not match an authentication request");
            throw new RuntimeException("Response does not match an authentication request");
        }
        this.samlRequestStore.removeRequest(samlResponse.getInResponseTo());
    }

    private void verifyConditions(Conditions conditions, SAMLMessageContext samlMessageContext) throws SAMLException {
        this.verifyExpirationConditions(conditions);
    }

    private void verifyExpirationConditions(Conditions conditions) throws SAMLException {
        log.debug("Verifying conditions");
        DateTime currentTime = new DateTime(DateTimeZone.UTC);
        log.debug("Current time in UTC : " + currentTime);
        DateTime notBefore = conditions.getNotBefore();
        log.debug("Not before condition : " + notBefore);
        if (notBefore != null && currentTime.isBefore((ReadableInstant)notBefore)) {
            throw new SAMLException("Assertion is not conformed with notBefore condition");
        }
        DateTime notOnOrAfter = conditions.getNotOnOrAfter();
        log.debug("Not on or after condition : " + notOnOrAfter);
        if (notOnOrAfter != null && currentTime.isAfter((ReadableInstant)notOnOrAfter)) {
            throw new SAMLException("Assertion is not conformed with notOnOrAfter condition");
        }
    }
}

