/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Person;
import com.imcode.entities.User;
import com.imcode.services.UserService;
import com.imcode.utils.StaticUtils;
import java.util.LinkedHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}/users"})
public class UserRestControllerImpl
extends AbstractRestController<User, Long, UserService> {
    @Autowired
    private UserService userService;

    @RequestMapping(method={RequestMethod.GET}, value={"/loggedin"})
    public Object getLoggedInUser(WebRequest webRequest) {
        User user = StaticUtils.getCurrentUser(webRequest, this.userService);
        LinkedHashMap<String, Object> loggedInUser = new LinkedHashMap<String, Object>();
        loggedInUser.put("id", user.getId());
        Person person = user.getPerson();
        loggedInUser.put("first_name", person.getFirstName());
        loggedInUser.put("last_name", person.getLastName());
        loggedInUser.put("roles", user.getRoles());
        return loggedInUser;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/current"})
    public User getCurrentUser(WebRequest webRequest) {
        return StaticUtils.getCurrentUser(webRequest, this.userService);
    }
}

