/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Incident;
import com.imcode.services.IncidentService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}/incidents"})
public class IncidentRestControllerImpl
extends AbstractRestController<Incident, Long, IncidentService> {
    @Autowired
    IncidentService incidentService;

    @Override
    public Object create(@RequestBody Incident entity, WebRequest webRequest) {
        entity.setReportDay(new Date());
        return super.create(entity, webRequest);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"search_text", "order_by"})
    public Object findByCriteria(@RequestParam(value="search_text") String searchText, @RequestParam(value="order_by") String orderBy, WebRequest webRequest) {
        if (orderBy.equals("title")) {
            return this.incidentService.findBySearchCriteria(searchText, orderBy);
        }
        return null;
    }
}

