/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.converters;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.util.StringUtils;

public class IdToDomainClassConverter<T extends ConversionService & ConverterRegistry>
extends DomainClassConverter<T> {
    private final T conversionService;
    private ToEntityConverter toEntityConverter;
    private ToIdConverter toIdConverter;
    private Repositories repositories;

    public IdToDomainClassConverter(T conversionService) {
        super(conversionService);
        this.conversionService = conversionService;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.repositories = new Repositories((ListableBeanFactory)context);
        this.toEntityConverter = new ToEntityConverter(this.repositories, (ConversionService)this.conversionService);
        ((ConverterRegistry)this.conversionService).addConverter((GenericConverter)this.toEntityConverter);
        this.toIdConverter = new ToIdConverter();
        ((ConverterRegistry)this.conversionService).addConverter((GenericConverter)this.toIdConverter);
    }

    public boolean isTypesEqual(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.equals((Object)targetType)) {
            return true;
        }
        if (sourceType.getType() == null && sourceType.getType() == targetType.getType()) {
            return true;
        }
        return sourceType.getType() != null && sourceType.getType().equals(targetType.getType());
    }

    private static final class ConversionMatchAbbreviationException
    extends RuntimeException {
        private ConversionMatchAbbreviationException() {
        }
    }

    private class ToIdConverter
    implements ConditionalGenericConverter {
        private ToIdConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null || !StringUtils.hasText((String)source.toString())) {
                return null;
            }
            if (IdToDomainClassConverter.this.isTypesEqual(sourceType, targetType)) {
                return source;
            }
            Class domainType = sourceType.getType();
            EntityInformation entityInformation = IdToDomainClassConverter.this.repositories.getEntityInformationFor(domainType);
            return IdToDomainClassConverter.this.conversionService.convert((Object)entityInformation.getId(source), targetType.getType());
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!IdToDomainClassConverter.this.repositories.hasRepositoryFor(sourceType.getType())) {
                return false;
            }
            if (sourceType.equals((Object)targetType)) {
                return true;
            }
            Class rawIdType = IdToDomainClassConverter.this.repositories.getRepositoryInformationFor(sourceType.getType()).getIdType();
            return targetType.equals((Object)TypeDescriptor.valueOf((Class)rawIdType)) || IdToDomainClassConverter.this.conversionService.canConvert(rawIdType, targetType.getType());
        }
    }

    private class ToEntityConverter
    implements ConditionalGenericConverter {
        private final RepositoryInvokerFactory repositoryInvokerFactory;

        public ToEntityConverter(Repositories repositories, ConversionService conversionService) {
            this.repositoryInvokerFactory = new DefaultRepositoryInvokerFactory(repositories, conversionService);
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null || !StringUtils.hasText((String)source.toString())) {
                return null;
            }
            if (IdToDomainClassConverter.this.isTypesEqual(sourceType, targetType)) {
                return source;
            }
            Class domainType = targetType.getType();
            RepositoryInformation info = IdToDomainClassConverter.this.repositories.getRepositoryInformationFor(domainType);
            RepositoryInvoker invoker = this.repositoryInvokerFactory.getInvokerFor(domainType);
            return invoker.invokeFindOne((Serializable)IdToDomainClassConverter.this.conversionService.convert(source, info.getIdType()));
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!IdToDomainClassConverter.this.repositories.hasRepositoryFor(targetType.getType())) {
                return false;
            }
            if (IdToDomainClassConverter.this.isTypesEqual(sourceType, targetType)) {
                return true;
            }
            Class rawIdType = IdToDomainClassConverter.this.repositories.getRepositoryInformationFor(targetType.getType()).getIdType();
            return sourceType.equals((Object)TypeDescriptor.valueOf((Class)rawIdType)) || IdToDomainClassConverter.this.conversionService.canConvert(sourceType.getType(), rawIdType);
        }
    }
}

