/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.utils;

import com.imcode.entities.Activity;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class IssueAttachmentFileUtil {
    public void saveActivityAttachment(Activity activity, MultipartFile attachment) {
        File serverFile;
        String filePath = this.generateFilePath(activity);
        byte[] bytes = null;
        try {
            bytes = attachment.getBytes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File dir = new File(filePath.substring(0, filePath.lastIndexOf("/")));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(serverFile = new File(filePath)).exists()) {
            try {
                serverFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            attachment.transferTo(serverFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveActivityAttachmentInResponse(Activity activity, HttpServletResponse response) {
        String filePath = this.generateFilePath(activity);
        File initialFile = new File(filePath);
        response.setContentType("application/force-download");
        response.setContentLength((int)initialFile.length());
        response.setHeader("Content-Transfer-Encoding", "binary");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + activity.getFileName() + "\"");
        BufferedInputStream targetStream = null;
        try {
            targetStream = new BufferedInputStream(new FileInputStream(initialFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            FileCopyUtils.copy((InputStream)targetStream, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String generateFilePath(Activity activity) {
        Properties property = new Properties();
        String pathToIssues = null;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("issues.properties");
        try {
            property.load(inputStream);
            pathToIssues = property.getProperty("pathToIssues");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuilder path = new StringBuilder(pathToIssues + "/");
        path.append(activity.getIssue().getId());
        path.append("/activities/");
        path.append(activity.getId() + "/");
        path.append(activity.getFileName());
        return path.toString();
    }
}

